package com.bizvane.connectorservice.entity.common;

import com.bizvane.connectorservice.entity.base.BaseModel;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Auther: xiao.shu
 * @Date: 2019/7/11 14:43
 * @Description:
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
public class OrderAddSendedRequestVO extends BaseModel {

    /**
     * 订单状态:物流状态 0未发货 1已发货 2已收货
     */
    private String logisticsStatus;
    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 下单时间
     */
    private Date orderTime;

    /**
     * 收货人：姓名
     */
    private String consigneeName;

    /**
     * 收货人：手机号
     */
    private String consigneePhone;

    /**
     * 收货人：省
     */
    private String consigneeProvince;

    /**
     * 收货人：市
     */
    private String consigneeCity;

    /**
     * 收货人：区
     */
    private String consigneeArea;

    /**
     * 收货人：街道
     */
    private String consigneeStreet;

    /**
     * 收货人：详细地址
     */
    private String consigneeDetailed;

    /**
     * 会员id(线下会员id)
     */
    private String erpId;

    /**
     * 会员门店id(线下门店id)
     */
    private String erpStoreId;

    /**
     * 会员门店code(线下门店code)
     */
    private String erpStoreCode;

    /**
     * 会员导购id(线下导购id)
     */
    private String erpGuideId;

    /**
     * 会员导购code(线下导购code)
     */
    private String erpGuideCode;

    /**
     * 成交金额
     */
    private BigDecimal commodityAmount;

    /**
     * 商品金额(订单总成交金额)
     */
    private BigDecimal standardAmount;

    /**与微商城协商0722 按第二种注释走
     * 标准金额(订单总标金额)
     * 优惠金额(优惠券抵扣金额)
     */
    private BigDecimal preferentialAmount;

    /**
     * 优惠金额(优惠券抵扣金额)
     * 抵扣金额(积分抵扣金额)
     */
    private BigDecimal deductibleAmount;

    /**
     * 抵扣金额(积分抵扣金额)
     *  其他优惠金额(满减  满包邮)
     */
    private BigDecimal otherPreferentialVolume;

    /**
     * 其他优惠金额(满减  满包邮)
     * 应收金额
     */
    private BigDecimal receivableAmount;

    /**
     * 应收金额
     */
    private BigDecimal transactionAmount;

    /**
     * 是否包邮(Y / N)
     */
    private String isPost;

    /**
     * 邮费
     */
    private BigDecimal postage;

    /**
     * 支付金额
     */
    private BigDecimal payMoney;

    /**
     * 券号
     */
    private String vipcouponCode;

    /**
     * 商品数组
     */
    private List<OrderItemRequestVO> orderItem;

    /**
     * 商品总数量
     */
    private Integer productCount;

    /**
     * 1.微商城订单,2.积分商城订单
     */
    private Integer orderType = 1;

    /**
     * 订单总积分
     */
    private Integer costPoints;



    /**
     * 线下会员姓名
     */
    private String vipName;

    /**
     * 线下会员卡号
     */
    private String offlineCardNo;

    /**
     * 配送方式：0：寄货到家、1：到店自提
     * 未使用
     */
    private String shippingMode;



    public String getLogisticsStatus() {
        return logisticsStatus;
    }

    public void setLogisticsStatus(String logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    public String getConsigneeName() {
        return consigneeName;
    }

    public void setConsigneeName(String consigneeName) {
        this.consigneeName = consigneeName;
    }

    public String getConsigneePhone() {
        return consigneePhone;
    }

    public void setConsigneePhone(String consigneePhone) {
        this.consigneePhone = consigneePhone;
    }

    public String getConsigneeProvince() {
        return consigneeProvince;
    }

    public void setConsigneeProvince(String consigneeProvince) {
        this.consigneeProvince = consigneeProvince;
    }

    public String getConsigneeCity() {
        return consigneeCity;
    }

    public void setConsigneeCity(String consigneeCity) {
        this.consigneeCity = consigneeCity;
    }

    public String getConsigneeArea() {
        return consigneeArea;
    }

    public void setConsigneeArea(String consigneeArea) {
        this.consigneeArea = consigneeArea;
    }

    public String getConsigneeStreet() {
        return consigneeStreet;
    }

    public void setConsigneeStreet(String consigneeStreet) {
        this.consigneeStreet = consigneeStreet;
    }

    public String getConsigneeDetailed() {
        return consigneeDetailed;
    }

    public void setConsigneeDetailed(String consigneeDetailed) {
        this.consigneeDetailed = consigneeDetailed;
    }

    public String getErpId() {
        return erpId;
    }

    public void setErpId(String erpId) {
        this.erpId = erpId;
    }

    public String getErpStoreId() {
        return erpStoreId;
    }

    public void setErpStoreId(String erpStoreId) {
        this.erpStoreId = erpStoreId;
    }

    public String getErpGuideId() {
        return erpGuideId;
    }

    public void setErpGuideId(String erpGuideId) {
        this.erpGuideId = erpGuideId;
    }

    public BigDecimal getCommodityAmount() {
        return commodityAmount;
    }

    public void setCommodityAmount(BigDecimal commodityAmount) {
        this.commodityAmount = commodityAmount;
    }

    public BigDecimal getStandardAmount() {
        return standardAmount;
    }

    public void setStandardAmount(BigDecimal standardAmount) {
        this.standardAmount = standardAmount;
    }

    public BigDecimal getPreferentialAmount() {
        return preferentialAmount;
    }

    public void setPreferentialAmount(BigDecimal preferentialAmount) {
        this.preferentialAmount = preferentialAmount;
    }

    public BigDecimal getDeductibleAmount() {
        return deductibleAmount;
    }

    public void setDeductibleAmount(BigDecimal deductibleAmount) {
        this.deductibleAmount = deductibleAmount;
    }

    public BigDecimal getOtherPreferentialVolume() {
        return otherPreferentialVolume;
    }

    public void setOtherPreferentialVolume(BigDecimal otherPreferentialVolume) {
        this.otherPreferentialVolume = otherPreferentialVolume;
    }

    public BigDecimal getReceivableAmount() {
        return receivableAmount;
    }

    public void setReceivableAmount(BigDecimal receivableAmount) {
        this.receivableAmount = receivableAmount;
    }

    public BigDecimal getTransactionAmount() {
        return transactionAmount;
    }

    public void setTransactionAmount(BigDecimal transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public String getIsPost() {
        return isPost;
    }

    public void setIsPost(String isPost) {
        this.isPost = isPost;
    }

    public BigDecimal getPostage() {
        return postage;
    }

    public void setPostage(BigDecimal postage) {
        this.postage = postage;
    }

    public BigDecimal getPayMoney() {
        return payMoney;
    }

    public void setPayMoney(BigDecimal payMoney) {
        this.payMoney = payMoney;
    }

    public String getVipcouponCode() {
        return vipcouponCode;
    }

    public void setVipcouponCode(String vipcouponCode) {
        this.vipcouponCode = vipcouponCode;
    }

    public List<OrderItemRequestVO> getOrderItem() {
        return orderItem;
    }

    public void setOrderItem(List<OrderItemRequestVO> orderItem) {
        this.orderItem = orderItem;
    }

    public Integer getProductCount() {
        return productCount;
    }

    public void setProductCount(Integer productCount) {
        this.productCount = productCount;
    }

    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public Integer getCostPoints() {
        return costPoints;
    }

    public void setCostPoints(Integer costPoints) {
        this.costPoints = costPoints;
    }

    public String getVipName() {
        return vipName;
    }

    public void setVipName(String vipName) {
        this.vipName = vipName;
    }

    public String getOfflineCardNo() {
        return offlineCardNo;
    }

    public void setOfflineCardNo(String offlineCardNo) {
        this.offlineCardNo = offlineCardNo;
    }

    public String getShippingMode() {
        return shippingMode;
    }

    public void setShippingMode(String shippingMode) {
        this.shippingMode = shippingMode;
    }

    public String getErpStoreCode() {
        return erpStoreCode;
    }

    public void setErpStoreCode(String erpStoreCode) {
        this.erpStoreCode = erpStoreCode;
    }

    public String getErpGuideCode() {
        return erpGuideCode;
    }

    public void setErpGuideCode(String erpGuideCode) {
        this.erpGuideCode = erpGuideCode;
    }
}
