package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.IntegralAdjustResponseVO;
import com.bizvane.connectorservice.entity.icrm.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import java.util.List;

/**
 * @author xiao.shu
 * @date 2019/10/15
 * @description
 */

@FeignClient(value = "${feign.client.connector.name}",path = "${feign.client.connector.path}/icrm")
public interface IcrmConnectorServiceFeign {


    /**
     *  商品档案类:获取客户信息
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "getDistributorList", method = RequestMethod.POST)
    Result<StoreResponseVO> getDistributorList(@RequestBody DistributorRequestVO requestVO);

    /**
     *  会员类:新增VIP卡，新增（修改）顾客资料
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "addVip", method = RequestMethod.POST)
    Result<AddVipResponseVO> addVip(@RequestBody AddVipRequestVO requestVO);
    /**
     * 消费类:新增消费
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "addConsume", method = RequestMethod.POST)
    Result addConsume(@RequestBody AddConsumeRequestVO requestVO);
    /**
     *  积分类:新增积分流水
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "addIntegral", method = RequestMethod.POST)
    Result<IntegralAdjustResponseVO> addIntegral(@RequestBody AddIntegralRequestVO requestVO);

    /**
     *  档案类:获取门店店员信息
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "getAssistantList", method = RequestMethod.POST)
    Result<AssistantListResponseVO> getAssistantList(@RequestBody AssistantRequestVO requestVO);

}
