package com.bizvane.connectorservice.util;


import com.alibaba.fastjson.JSONObject;
import com.bizvane.connectorservice.entity.po.ConnectConfig;
import com.bizvane.connectorservice.entity.po.ConnectConfigBean;
import com.bizvane.connectorservice.interfaces.online.ConnectConfigBeanService;
import com.bizvane.connectorservice.interfaces.online.ConnectConfigService;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.*;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

/**
 * @Auther: xiao.shu
 * @Date: 2019/10/21 15:01
 * @Description:
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
@Component
public class IcrmUtil {

    @Autowired
    private RedisTemplateServiceImpl redisTemplateService;

    @Autowired
    private ConnectConfigService connectConfigService;

    @Autowired
    private  ConnectConfigBeanService connectConfigBeanService;


    public  String getSign(String icrmkey ,String appSecret) {
        //获取当前年月日:
        String year = String.valueOf(Calendar.getInstance().get(Calendar.YEAR));
        String month = String.valueOf(Calendar.getInstance().get(Calendar.MONTH) + 1);
        String day = String.valueOf(Calendar.getInstance().get(Calendar.DATE));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(icrmkey).append(appSecret).append(year + month + day);
        return MD5Util.MD5Encode(stringBuilder.toString());
    }


    public  org.json.JSONObject getJsonObject(Object requestVO)  {
        Class cls = requestVO.getClass();
        Field[] fields = cls.getDeclaredFields();
        org.json.JSONObject jsonObject = new org.json.JSONObject();
        for (int i = 0; i < fields.length; i++) {
            Field f = fields[i];
            f.setAccessible(true);
            JSONObject jsonObject1 = new JSONObject();
            try {
                System.out.println("属性名:" + f.getName() + " 属性值:" + f.get(requestVO));
                if(f.get(requestVO)!=null&& (f.get(requestVO).toString().contains("com.bizvane.connectorservice.entity.icrm.ConsumeVO"))){
                    Field[] fields1 =  f.get(requestVO).getClass().getDeclaredFields();
                    if(fields1!=null&&fields1.length>0){

                    for (int j = 0; j < fields1.length; j++) {
                        Field f1 = fields1[j];
                        f1.setAccessible(true);
                        System.out.println("属性名:" + f1.getName() + " 属性值:" +f1.get(f.get(requestVO)));
                        jsonObject1.put(f1.getName(), f1.get(f.get(requestVO)));
                    }
                        jsonObject.put(f.getName(), jsonObject1);
                }
                } else if(List.class.isAssignableFrom(f.getType())){
                    Type t = f.getGenericType();
                    JSONArray  jsonArray = new JSONArray();
                    if (t instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType) t;
                        Class clz = (Class) pt.getActualTypeArguments()[0];//得到对象list中实例的类型
                        Class clazz = f.get(requestVO).getClass();//获取到属性的值的Class对象
                        Method m= null;
                        try {
                            m = clazz.getDeclaredMethod("size");
                        } catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        }
                        int size = 0;//调用list的size方法，得到list的长度
                        try {
                            size = (Integer) m.invoke(f.get(requestVO));
                        } catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }

                        for (int k = 0; k < size; k++) {//遍历list，调用get方法，获取list中的对象实例
                            Method getM= null;
                            JSONObject jsonObject3=new JSONObject();
                            try {
                                getM = clazz.getDeclaredMethod("get", int.class);
                            } catch (NoSuchMethodException e) {
                                e.printStackTrace();
                            }
                            if(!getM.isAccessible()){
                                getM.setAccessible(true);
                            }
                            try {
                                //获取到的具体的每个对象
                                Object invoke = getM.invoke(f.get(requestVO), k);
                                Class classC = invoke.getClass();
                                Field[] fields2 = classC.getDeclaredFields();
                                for (int n = 0; n < fields2.length; n++) {
                                    Field f2 = fields2[n];
                                    f2.setAccessible(true);
                                    jsonObject3.put(f2.getName(), f2.get(invoke));
                                }
                            } catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                            jsonArray.put(jsonObject3);
                        }
                    }
                    jsonObject.put(f.getName(),jsonArray);
                } else {
                    jsonObject.put(f.getName(), f.get(requestVO));
                }
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        Class clss = requestVO.getClass().getSuperclass();
        Field[] fieldss = clss.getDeclaredFields();
        if(fieldss!=null&&fieldss.length>0){
        for (int i = 0; i < fieldss.length; i++) {
            Field f = fieldss[i];
            f.setAccessible(true);
            try {
                System.out.println("属性名:" + f.getName() + " 属性值:" + f.get(requestVO));
                jsonObject.put(f.getName(), f.get(requestVO));
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }}
        return jsonObject;
    }


    public  String getDomain(Long brandId) {
        if (null == brandId) {
            return null;
        }
        ConnectConfigBean connectConfigBean = (ConnectConfigBean)redisTemplateService.stringGetStringByKey("icrmBean" + brandId);
        if (connectConfigBean == null) {
            connectConfigBean = connectConfigBeanService.queryBeanNameByBrandId(brandId);
            if (null==connectConfigBean||(!"icrm".equals(connectConfigBean.getBeanName()))) {
                return null;
            }
            redisTemplateService.stringSetString("icrmBean"+brandId,connectConfigBean);
        }
        ConnectConfig connectConfig =(ConnectConfig) redisTemplateService.stringGetStringByKey("icrmBeanDomain" + brandId);
        String domain=null;
        if (connectConfig == null) {
            connectConfig = connectConfigService.queryByOnlineBrandId(brandId);
            domain = connectConfig.getDomain();
            if (null==connectConfig|| StringUtils.isBlank(domain)) {
                return null;
            }
            redisTemplateService.stringSetString("icrmBeanDomain"+brandId,connectConfig);
        }else{
            domain=connectConfig.getDomain();
        }
        return domain;
    }


    public static String getUrlByGet(String url, org.json.JSONObject jsonObject) throws UnsupportedEncodingException {
        if (jsonObject == null) {
            return url;
        }
        if (StringUtil.isNull(url)) {
            return url;
        }
        Iterator<String> keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            System.out.println(key);
            String value = jsonObject.optString(key);
            value = URLEncoder.encode(value, "UTF-8");
            System.out.println(value);
            if (url.indexOf("?") > 0) {
                url = url + "&" + key + "=" + value;
            } else {
                url = url + "?" + key + "=" + value;
            }
        }
        return url;
    }
}
