package com.bizvane.connectorservice.util;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.util.Arrays;
import java.util.List;
public class SpringUtil implements ApplicationContextAware {

    private static ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (SpringUtil.applicationContext == null) {
            SpringUtil.applicationContext = applicationContext;
        }
        System.out.println("---------------------------------------------------------------------");

        System.out.println("========ApplicationContext配置成功,在普通类可以通过Spring注入SpringUtil,然后直接通过注入对象操作,applicationContext=" + SpringUtil.applicationContext + "========");

        System.out.println("---------------------------------------------------------------------");
    }

    /**
     * 获取applicationContext
     * @return
     */
    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    /**
     * 通过name获取 Bean
     */
    public static Object getBean(String name) {
        return getApplicationContext().getBean(name);
    }

    /**
     * 通过class获取Bean.
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T getBean(Class<T> clazz) {
        return getApplicationContext().getBean(clazz);
    }

    /**
     * 通过name,以及Clazz返回指定的Bean
     * @param name
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T getBean(String name, Class<T> clazz) {
        return getApplicationContext().getBean(name, clazz);
    }

    /**
     * 通过class获取所有BeanName
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> List<String> getBeanNamesByType(Class<T> clazz) {
        String[] beanNamesForType = getApplicationContext().getBeanNamesForType(clazz);
        int length = beanNamesForType.length;
        if(length == 0){
            return null;
        }
        return Arrays.asList(beanNamesForType);
    }

}
