package com.bizvane.connectorservice.interfaces.rpc;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author liuying
 * @date 2018/8/15
 * @description
 */

@FeignClient(value = "${feign.client.connector.name}",path = "${feign.client.connector.path}/rest")
public interface ConnectorServiceFeign {

    /**
     * 调整积分
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "adjustintegral", method = RequestMethod.POST)
    Result<IntegralAdjustResponseVO> adjustIntegral(@RequestBody IntegralAdjustRequestVO requestVO);

    /**
     * 登陆,绑卡
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "login", method = RequestMethod.POST)
    Result<MemberLoginResponseVO> login(@RequestBody MemberLoginRequestVO requestVO);

    /**
     * 线下开卡
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "opencard", method = RequestMethod.POST)
    Result<MemberOpenCardResponseVO> opencard(@RequestBody MemberOpenCardRequestVO requestVO);

    /**
     * 修改手机号
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "modifyphone", method = RequestMethod.POST)
    Result modifyphone(@RequestBody MemberPhoneUpdateRequestVO requestVO);

    /**
     * 单张发券
     * @param requestVo
     * @return
     */
    @RequestMapping(value = "singlecoupon", method = RequestMethod.POST)
    Result singlecoupon(@RequestBody CouponRequestVO requestVo);

    /**
     * 批量发券
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "batchcoupon", method = RequestMethod.POST)
    Result batchcoupon(@RequestBody CouponBatchRequestVO requestVO);

    /**
     * 券转增
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "givecoupon", method = RequestMethod.POST)
    Result givecoupon(@RequestBody CouponGiveRequestVO requestVO);

    /**
     * 券核销
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "usecoupon", method = RequestMethod.POST)
    Result usecoupon(@RequestBody CouponUseRequestVO requestVO);

    /**
     * 新增线下订单
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "addorder", method = RequestMethod.POST)
    Result addorder(@RequestBody OrderAddRequestVO requestVO);

    /**
     * 新增线下退单（按详情退）
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "refundorder", method = RequestMethod.POST)
    Result refundOrder(@RequestBody OrderRefundRequestVO requestVO);


    /**
     * 新增退款单
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "refundgoods", method = RequestMethod.POST)
    Result refundGoods(@RequestBody OrderRefundGoodRequestVO requestVO);

    /**
     * 修改支付密码接口
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "modifypaymentpassword", method = RequestMethod.POST)
    Result modifyPaymentPassword(@RequestBody PaymentPasswordRequestVO requestVO);


    /**
     * 批量线下券绑定
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "batchcouponbind", method = RequestMethod.POST)
    Result batchCouponBind(@RequestBody CouponBatchBindRequestVO requestVO);

    /**
     * 单张线下券绑定
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "singlecouponbind", method = RequestMethod.POST)
    Result singleCouponBind(@RequestBody CouponBindRequestVO requestVO);

    /**
     * 会员升降级
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "modifymembergrade", method = RequestMethod.POST)
    Result modifyMemberGrade(@RequestBody MemberModifyGradeRequestVO requestVO);

}
