package com.bizvane.connectorservice.interfaces.online;

/**
 * @author liuying
 * @date 2018/8/29
 * @description
 */

public interface ConnectMethodConfigService {

    /**
     * 根据redis中ConnectConfig数据获取品牌,按品牌从db加载t_connect_method_config表进redis
     */
    void refreshRedisAll();

    /**
     * 根据品牌id刷新品牌方法列表
     * @param onlineBrandId
     * @return
     */
    Boolean checkAndRefreshRedisMethodNamesByOnlineBrandId(Long onlineBrandId,String methodName);


    /**
     * 根据品牌id刷新品牌url列表
     * @param onlineBrandId
     * @return
     */
    Boolean checkAndRefreshRedisMethodUrlsByOnlineBrandId(Long onlineBrandId,String methodUrl);
}
