/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.tenant;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.OnExceptionContext;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.SpringContextHolder;
import com.bizvane.utils.tenant.QuarantineAnnotation;
import com.bizvane.utils.tenant.QuarantineContextHolder;
import com.bizvane.utils.tenant.QuarantineEntity;
import com.bizvane.utils.tenant.QuarantineInterceptsBean;
import com.bizvane.utils.tokens.JWTUtil;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StopWatch;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class QuarantineIntercepts
implements Interceptor {
    public static final Logger logger = LoggerFactory.getLogger(QuarantineIntercepts.class);
    public static final String ENABLE_INTERCEPTS = "enableIntercepts";
    public static final String IGNORE_TABLE = "ignoreTable";
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";
    public static final String COMPANY_ID = "sys_company_id";
    private static final String SQL_SELECT = "sql_select";
    private static final String PUBLIC_BIZVANE_SQL_INTERCEPT_BEAN = "public_bizvane_sql_intercept_bean";

    public HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null == requestAttributes) {
            return null;
        }
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object object;
        SysAccountPO sysAccountPO;
        String sql;
        String obj;
        BoundSql boundSql;
        block15: {
            boolean userIdentity;
            block14: {
                block13: {
                    QuarantineInterceptsBean bean = new QuarantineInterceptsBean();
                    RoutingStatementHandler handler = (RoutingStatementHandler)invocation.getTarget();
                    StatementHandler delegate = (StatementHandler)ReflectUtil.getFieldValue(handler, "delegate");
                    MappedStatement mappedStatement = (MappedStatement)ReflectUtil.getFieldValue(delegate, "mappedStatement");
                    Class<?> classType = Class.forName(mappedStatement.getId().substring(0, mappedStatement.getId().lastIndexOf(".")));
                    String mName = mappedStatement.getId().substring(mappedStatement.getId().lastIndexOf(".") + 1);
                    boolean flag = this.skipIntercepts(classType, mName);
                    boundSql = delegate.getBoundSql();
                    obj = boundSql.getSql().replaceAll("[\\s]+", " ");
                    sql = null;
                    userIdentity = true;
                    if (SqlCommandType.SELECT == mappedStatement.getSqlCommandType() && !flag) break block13;
                    Object object2 = invocation.proceed();
                    {
                        catch (Throwable throwable) {
                            if (StringUtils.startsWithAny((CharSequence)InetAddress.getLocalHost().getHostName(), (CharSequence[])new CharSequence[]{"app", "new"})) {
                                // empty if block
                            }
                            throw throwable;
                        }
                    }
                    if (StringUtils.startsWithAny((CharSequence)InetAddress.getLocalHost().getHostName(), (CharSequence[])new CharSequence[]{"app", "new"})) {
                        // empty if block
                    }
                    return object2;
                }
                if (!this.validatorIntercepts()) break block14;
                Object object3 = invocation.proceed();
                if (StringUtils.startsWithAny((CharSequence)InetAddress.getLocalHost().getHostName(), (CharSequence[])new CharSequence[]{"app", "new"})) {
                    // empty if block
                }
                return object3;
            }
            sysAccountPO = TokenUtils.getStageUser(this.getRequest());
            if (null != sysAccountPO && null != sysAccountPO.getSysCompanyId() && 0L != sysAccountPO.getSysCompanyId()) break block15;
            userIdentity = false;
            Object object4 = invocation.proceed();
            if (StringUtils.startsWithAny((CharSequence)InetAddress.getLocalHost().getHostName(), (CharSequence[])new CharSequence[]{"app", "new"})) {
                // empty if block
            }
            return object4;
        }
        StopWatch sw = new StopWatch("sql\u6267\u884c\u603b\u8017\u65f6");
        try {
            sw.start("\u62fc\u63a5\u8017\u65f6");
            sql = QuarantineIntercepts.buildQuery(obj, sysAccountPO.getSysCompanyId().toString());
            ReflectUtil.setFieldValue(boundSql, "sql", sql);
            sw.stop();
            sw.start("\u8fd0\u884c\u8017\u65f6");
            object = invocation.proceed();
        }
        catch (Throwable throwable) {
            sw.stop();
            logger.info(sw.prettyPrint());
            logger.info("sql\u6267\u884c\u603b\u8017\u65f6\uff1a[{}ms]", (Object)sw.getTotalTimeMillis());
            throw throwable;
        }
        sw.stop();
        logger.info(sw.prettyPrint());
        logger.info("sql\u6267\u884c\u603b\u8017\u65f6\uff1a[{}ms]", (Object)sw.getTotalTimeMillis());
        if (StringUtils.startsWithAny((CharSequence)InetAddress.getLocalHost().getHostName(), (CharSequence[])new CharSequence[]{"app", "new"})) {
            // empty if block
        }
        return object;
    }

    protected boolean skipIntercepts(Class<?> classType, String mName) {
        if (StringUtils.endsWith((CharSequence)mName, (CharSequence)"_COUNT")) {
            String subMethodName = StringUtils.substringBefore((String)mName, (String)"_COUNT");
            Method[] methodArray = classType.getDeclaredMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Method method = methodArray[i];
                if (!subMethodName.equals(method.getName()) || !method.isAnnotationPresent(QuarantineAnnotation.class)) continue;
                return true;
            }
        }
        if (classType.isAnnotationPresent(QuarantineAnnotation.class)) {
            return true;
        }
        for (Method method : classType.getDeclaredMethods()) {
            if (!mName.equals(method.getName()) || !method.isAnnotationPresent(QuarantineAnnotation.class)) continue;
            return true;
        }
        return true;
    }

    public static SysAccountPO getStageUser(HttpServletRequest request) {
        String sysAccountPoString = request.getHeader("stageToken");
        return JWTUtil.unsign(sysAccountPoString, SysAccountPO.class);
    }

    public static String addCompanyIdCondition(String coreQuery, String companyId) {
        Select select = QuarantineIntercepts.createSelect(coreQuery);
        PlainSelect plainSelect = QuarantineIntercepts.getPlainSelect(select);
        if (plainSelect.getFromItem() instanceof Table) {
            Table table = (Table)plainSelect.getFromItem();
            QuarantineIntercepts.appendCondition(companyId, table, select, plainSelect);
        }
        if (plainSelect.getFromItem() instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)plainSelect.getFromItem();
            SelectBody selectBody = subSelect.getSelectBody();
            Select select1 = QuarantineIntercepts.createSelect(selectBody.toString());
            PlainSelect plainSelect1 = QuarantineIntercepts.getPlainSelect(select1);
            Table table = (Table)plainSelect1.getFromItem();
            QuarantineIntercepts.appendCondition(companyId, table, select1, plainSelect1);
            ((SubSelect)plainSelect.getFromItem()).setSelectBody((SelectBody)plainSelect1);
        }
        return select.toString();
    }

    protected static void appendCondition(String companyId, Table table, Select select, PlainSelect plainSelect) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (null != table.getAlias() && StringUtils.isNotBlank((CharSequence)table.getAlias().getName())) {
            map.put(table.getName(), table.getAlias().getName());
        } else {
            map.put(table.getName(), "${}");
        }
        if (null != plainSelect.getJoins()) {
            for (Join join : plainSelect.getJoins()) {
                Table rightItem = (Table)join.getRightItem();
                if (rightItem.getAlias() == null || StringUtils.isBlank((CharSequence)rightItem.getAlias().getName())) {
                    map.put(rightItem.getName(), "${}");
                    continue;
                }
                map.put(rightItem.getName(), rightItem.getAlias().getName());
            }
        }
        List<String> ignoreTableList = QuarantineIntercepts.getAllIgnoreTable();
        boolean flag = false;
        if (CollectionUtils.isNotEmpty(ignoreTableList)) {
            for (String str : ignoreTableList) {
                if (!map.containsKey(str)) continue;
                flag = true;
                break;
            }
        }
        if (!flag) {
            String alias = "";
            EqualsTo equalsTo = new EqualsTo();
            for (Map.Entry entry : map.entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                alias = (String)entry.getValue();
                break;
            }
            StringBuffer sb = new StringBuffer();
            if (StringUtils.isNotBlank((CharSequence)alias) && !"${}".equals(alias)) {
                sb.append(alias).append(".").append(COMPANY_ID);
            } else {
                sb.append(COMPANY_ID);
            }
            equalsTo.setLeftExpression((Expression)new Column(sb.toString()));
            equalsTo.setRightExpression((Expression)new LongValue(companyId));
            QuarantineIntercepts.addWhereCondition(select, (Expression)equalsTo);
        }
    }

    public static String buildQuery(String sql, String condition) {
        return QuarantineIntercepts.addCompanyIdCondition(sql, condition);
    }

    public static Select createSelect(String sql) {
        try {
            return (Select)CCJSqlParserUtil.parse((String)sql);
        }
        catch (JSQLParserException e) {
            throw new IllegalStateException("SQL parsing problem!", e);
        }
    }

    public static void addWhereCondition(Select select, Expression condition) {
        QuarantineIntercepts.addWhereCondition(QuarantineIntercepts.getPlainSelect(select), condition);
    }

    private static void addWhereCondition(PlainSelect plainSelect, Expression condition) {
        if (plainSelect.getWhere() == null) {
            plainSelect.setWhere(condition);
            return;
        }
        AndExpression andExpression = new AndExpression(plainSelect.getWhere(), condition);
        plainSelect.setWhere((Expression)andExpression);
    }

    private static PlainSelect getPlainSelect(Select select) {
        if (select.getSelectBody() instanceof PlainSelect) {
            return (PlainSelect)select.getSelectBody();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public static List<String> getAllIgnoreTable() {
        if (QuarantineIntercepts.isaBoolean()) {
            return null;
        }
        return Arrays.asList(StringUtils.split((String)QuarantineContextHolder.getQuarantine.getIgnoreTable(), (String)","));
    }

    private boolean validatorIntercepts() {
        if (null == QuarantineContextHolder.getQuarantine || StringUtils.isBlank((CharSequence)QuarantineContextHolder.getQuarantine.getEnableIntercepts()) || DISABLE.equals(QuarantineContextHolder.getQuarantine.getEnableIntercepts()) || null == this.getRequest()) {
            return true;
        }
        return !ENABLE.equals(QuarantineContextHolder.getQuarantine.getEnableIntercepts());
    }

    private static boolean isaBoolean() {
        return null == QuarantineContextHolder.getQuarantine || null == QuarantineContextHolder.getQuarantine.getIgnoreTable();
    }

    public void setProperties(Properties properties) {
        QuarantineEntity quarantineEntity = new QuarantineEntity();
        quarantineEntity.setEnableIntercepts((String)properties.get(ENABLE_INTERCEPTS));
        quarantineEntity.setIgnoreTable((String)properties.get(IGNORE_TABLE));
        QuarantineContextHolder.setQuarantineEntity(quarantineEntity);
    }

    protected void sendSQLBean(QuarantineInterceptsBean bean, MappedStatement mappedStatement, Class<?> classType, String mName, boolean flag, String obj, String sql, boolean userIdentity) {
        if (SqlCommandType.SELECT != mappedStatement.getSqlCommandType()) {
            return;
        }
        Producer producer = this.getProducer();
        if (producer == null) {
            return;
        }
        try {
            bean.setApplicationName(this.getApplicationName());
            bean.setClazz(classType.getName());
            bean.setMethod(mName);
            bean.setJoinBefore(obj);
            bean.setJoinAfter(sql);
            bean.setExcluded(flag ? 1 : 2);
            bean.setUserIdentity(userIdentity ? 1 : 2);
            bean.setCreateDate(new Date());
            bean.setUpdateDate(new Date());
            Message message = new Message();
            message.setTag(SQL_SELECT);
            message.setTopic(PUBLIC_BIZVANE_SQL_INTERCEPT_BEAN);
            message.setBody(JacksonUtil.bean2Json(bean).getBytes());
            producer.sendAsync(message, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    logger.debug("\u53d1\u9001\u62e6\u622asql\u6210\u529f\uff01", (Object)sendResult.getMessageId());
                }

                public void onException(OnExceptionContext onExceptionContext) {
                    logger.error("\u53d1\u9001sql\u62e6\u622a\u6570\u636e\u5f02\u5e38\uff01", (Throwable)onExceptionContext.getException());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u53d1\u9001sql\u62e6\u622a\u6570\u636e\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    private Producer getProducer() {
        Producer producer;
        try {
            Object object = SpringContextHolder.getBean("producer");
            if (!(object instanceof Producer)) {
                return null;
            }
            producer = (Producer)object;
        }
        catch (Exception var3) {
            logger.error("MQ\u7684\u53d1\u9001\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f!", (Throwable)var3);
            return null;
        }
        if (producer == null) {
            logger.error("MQ\u7684\u53d1\u9001\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f!");
            return null;
        }
        return producer;
    }

    private String getApplicationName() {
        Environment environment = null;
        try {
            environment = (Environment)SpringContextHolder.getBean("environment");
        }
        catch (Exception e) {
            logger.error("\u672a\u83b7\u53d6\u5230\u7cfb\u7edf\u53d8\u91cf\u5bf9\u8c61!", (Throwable)e);
            e.printStackTrace();
        }
        if (environment == null) {
            logger.error("\u7cfb\u7edf\u73af\u5883\u53d8\u91cf\u4e3a\u7a7a!");
            return null;
        }
        String applicationName = environment.getProperty("spring.application.name");
        if (StringUtils.isBlank((CharSequence)applicationName)) {
            logger.error("\u5e94\u7528\u540d\u4e3a\u7a7a!");
            return null;
        }
        return applicationName;
    }

    public static class ReflectUtil {
        public static Object getFieldValue(Object obj, String fieldName) {
            Object result = null;
            Field field = ReflectUtil.getField(obj, fieldName);
            if (field != null) {
                field.setAccessible(true);
                try {
                    result = field.get(obj);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }

        private static Field getField(Object obj, String fieldName) {
            Field field = null;
            Class<?> clazz = obj.getClass();
            while (clazz != Object.class) {
                if ("mappedStatement".equals(fieldName)) {
                    clazz = clazz.getSuperclass();
                }
                try {
                    field = clazz.getDeclaredField(fieldName);
                    break;
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
            return field;
        }

        public static void setFieldValue(Object obj, String fieldName, String fieldValue) {
            Field field = ReflectUtil.getField(obj, fieldName);
            if (field != null) {
                try {
                    field.setAccessible(true);
                    field.set(obj, fieldValue);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

