package com.bizvane.utils.tokens;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
/**
 * @Classname ZzSecurityHelper
 * @Description TODO
 * @Date 2019/6/24 16:50
 * @Created by whd
 */
public class AesUtils {
    
    private static String CHARSET = "utf-8";
    
    private static String ENCRYPT_MODEL = "AES/CBC/NoPadding";

    public static String encryptAES(String key, String iv, String data) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance(ENCRYPT_MODEL);
            int blockSize = cipher.getBlockSize();
            byte[] dataBytes = data.getBytes(CHARSET);
            int plaintextLength = dataBytes.length;

            if (plaintextLength % blockSize != 0) {
                plaintextLength = plaintextLength + (blockSize - (plaintextLength % blockSize));
            }

            byte[] plaintext = new byte[plaintextLength];
            System.arraycopy(dataBytes, 0, plaintext, 0, dataBytes.length);

            SecretKeySpec keyspec = new SecretKeySpec(key.getBytes(CHARSET), "AES");
            IvParameterSpec ivspec = new IvParameterSpec(iv.getBytes(CHARSET));  // CBC模式，需要一个向量iv，可增加加密算法的强度

            cipher.init(Cipher.ENCRYPT_MODE, keyspec, ivspec);
            byte[] encrypted = cipher.doFinal(plaintext);

            return AesUtils.encode(encrypted).trim(); // BASE64做转码。

        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptAES(String key, String iv, String data) throws Exception {
        try
        {
            byte[] encrypted1 = AesUtils.decode(data);

            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keyspec = new SecretKeySpec(key.getBytes(CHARSET), "AES");
            IvParameterSpec ivspec = new IvParameterSpec(iv.getBytes(CHARSET));

            cipher.init(Cipher.DECRYPT_MODE, keyspec, ivspec);

            byte[] original = cipher.doFinal(encrypted1);
            String originalString = new String(original);
            return originalString.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
    /**
     * 编码
     * @param byteArray
     * @return
     */
    public static String encode(byte[] byteArray) {
        return new String(new Base64().encode(byteArray));
    }

    /**
     * 解码
     * @param base64EncodedString
     * @return
     */
    public static byte[] decode(String base64EncodedString) {
        return new Base64().decode(base64EncodedString);
    }
    public static void main(String[] args) throws Exception {
      String s = encryptAES("@#@#@#@#@#@#@#@#", "@#@#@#@#@#@#@#@#", "23536476878769789790");
      System.out.println(s);
      String s2 = decryptAES("@#@#@#@#@#@#@#@#", "@#@#@#@#@#@#@#@#", s);
      System.out.println(s2);
    }
}