package com.bizvane.utils.enumutils;

public enum PaymentTradeRefundStatusEnum {
    PAY_REFUND_WAIT(0, "待退款"),
    PAY_REFUND_SUCCESS(1, "退款成功"),
    PAY_REFUND_FAIL(2, "退款失败");

    private Integer code;
    private String desc;

    PaymentTradeRefundStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }
    public String getDesc() {
        return desc;
    }
    public static PaymentTradeRefundStatusEnum getByCode(Integer code) {
        for (PaymentTradeRefundStatusEnum value : PaymentTradeRefundStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
