package com.bizvane.utils.jacksonutils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018\6\27 0027.
 */
public class JacksonUtil {

    private static final Logger LOG = LoggerFactory.getLogger(JacksonUtil.class);

    private static final ObjectMapper MAPPER;

    public static String ymdhms = "yyyy-MM-dd HH:mm:ss";


    static {
        // 使用 JsonMapper 以便更好的配置
        MAPPER = JsonMapper.builder()
                .serializationInclusion(JsonInclude.Include.ALWAYS)
                .configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)
                .configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)
                .build();

        // 设置日期格式
        MAPPER.setDateFormat(new SimpleDateFormat("yyyyMMddHHmmss"));

        // 注册 Java 8 时间模块
        MAPPER.registerModule(new JavaTimeModule());

        // 处理转义字符
        configureParser(MAPPER);
    }

    private static void configureParser(ObjectMapper mapper) {
        // 由于允许未引号的控制字符和字段名可能会带来安全问题，建议不要使用
        // 下面的方法是替代方案

        // 在这里可以添加定制的逻辑来处理控制字符
        // mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true); // 可根据业务需求决定是否使用
        // mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true); // 同上
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    /**
     * JavaBean ==> json
     *
     * @param bean
     * @return
     */
    public static <T> String bean2Json(T bean) {
        if (bean == null) {
            return null;
        }
        try {
            return MAPPER.writeValueAsString(bean);
        } catch (JsonProcessingException e) {
            LOG.error("JavaBean ===> JSON ERROR : {}", e.getMessage());
        }
        return null;
    }

    /**
     * JavaBean ==> map
     *
     * @param bean
     * @return
     */
    public static <T> Map<String, Object> bean2Map(T bean) {
        return json2Map(bean2Json(bean));
    }

    public static <T> Map<String, String> bean2Map1(T bean) {
        return json2Map1(bean2Json(bean));
    }

    /**
     * json ==> Object
     *
     * @param json
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T json2Obj(String json, Class<T> clazz) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        try {
            return MAPPER.readValue(json, clazz);
        } catch (IOException e) {
            LOG.error("JSON ==> {} ERROR : {}", clazz.getClass().getName(), e.getMessage());
        }
        return null;
    }



    /**
     * json ==> Object
     *
     * @param json
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T json2Objs(String json, Class<T> clazz) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        try {
            MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
           // MAPPER.writeValueAsString(json);
            return MAPPER.readValue(json, clazz);
        } catch (IOException e) {
            LOG.error("JSON ==> {} ERROR : {}", clazz.getClass().getName(), e.getMessage());
        }
        return null;
    }

    /**
     * json ==> Object[]
     *
     * @param json
     * @param classes
     * @param <T>
     * @return
     */
    public static <T> Class[] json2Array(String json, Class<T>[] classes) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        try {
            return MAPPER.readValue(json, classes.getClass());
        } catch (IOException e) {
            LOG.error("JSON ==> {} ERROR : {}", classes.getClass().getName(), e.getMessage());
        }
        return null;
    }

    public static String list2Json(List list) {
        if (CollectionUtils.isEmpty(list)){
            return "";
        }
        try {
            return MAPPER.writeValueAsString(list);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * json ==> Map
     *
     * @param json
     * @return
     */
    public static Map<String, Object> json2Map(String json) {
        return json2Obj(json, HashMap.class);
    }

    public static Map<String, String> json2Map1(String json) {
        return json2Objs(json, HashMap.class);
    }

    /**
     * json ==> List
     *
     * @param json
     * @return
     */
    public static List json2List(String json) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        try {
            return MAPPER.readValue(json, new TypeReference<List>() {
            });
        } catch (IOException e) {
            LOG.error("JSON ==> List ERROR : {}", e.getMessage());
        }
        return null;
    }

    /**
     * json ==> List
     *
     * @param json
     * @return
     */
    public static <T> List<T> json2List(String json, Class<T> t) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        try {
            JavaType javaType = MAPPER.getTypeFactory().constructParametricType(List.class, t);
            return MAPPER.readValue(json, javaType);
        } catch (IOException e) {
            LOG.error("JSON ==> List ERROR : {}", e.getMessage());
        }
        return null;
    }
}