package com.bizvane.utils.enumutils;

public enum PaymentFrozenRecordThawStatusEnum {
    PAY_FROZEN_RECORD_THAW_WAIT(0, "未处理"),
    PAY_FROZEN_RECORD_THAW_SUCCESS(1, "解冻成功"),
    PAY_FROZEN_RECORD_THAW_FAIL(2, "解冻失败");

    private Integer code;
    private String desc;

    PaymentFrozenRecordThawStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static PaymentFrozenRecordThawStatusEnum getByCode(Integer code) {
        for (PaymentFrozenRecordThawStatusEnum value : PaymentFrozenRecordThawStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }


}
