package com.bizvane.utils.enumutils;

import lombok.Getter;

import java.util.Objects;

/**
 * 审批业务枚举
 * 贡献值规则配置
 * 会员活动
 * 会员任务
 * 弹窗公告
 * 消息群发
 * 批量发券任务
 * 调查问卷
 * 员工福利维护
 */

@Getter
public enum ApproveBusinessEnum {

    CONFIGURE_POINTS_RULES("CONFIGURE_POINTS_RULES", "贡献值规则配置"),
    MEMBER_ACTIVITY("MEMBER_ACTIVITY", "会员活动"),
    MEMBER_TASK("MEMBER_TASK", "会员任务"),
    POP_UP_NOTICE("POP_UP_NOTICE", "弹窗广告"),
    SEND_MESSAGE_GROUP("SEND_MESSAGE_GROUP", "消息群发"),
    BATCH_SEND_COUPON("BATCH_SEND_COUPON", "批量发券任务"),
    QUESTIONNAIRES("QUESTIONNAIRES", "调查问卷"),
    STAFF_BENEFITS("STAFF_BENEFITS", "员工福利维护"),
    NOTIFICATION_ANNOUNCEMENT("NOTIFICATION_ANNOUNCEMENT", "通知公告"),
    ;
    private final String code;
    private final String value;

    ApproveBusinessEnum(String code, String value) {
        this.code = code;
        this.value = value;
    }

    public static ApproveBusinessEnum getValueByCode(String code) {
        for (ApproveBusinessEnum value : ApproveBusinessEnum.values()) {
            if (Objects.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }
}
