package com.bizvane.utils.enumutils;


public enum IntegralMallProductCouponTypeEnum {
    INTEGRAL_MALL_COUPON_PRODUCT_COUPON(1, "普通优惠券");
    private final Integer type;
    private final String typeDes;
    IntegralMallProductCouponTypeEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
    public static String getDescriptionByType(Integer type) {
        for (IntegralMallProductCouponTypeEnum deliveryEnum : IntegralMallProductCouponTypeEnum.values()) {
            if (deliveryEnum.getType().equals(type)) {
                return deliveryEnum.getTypeDes();
            }
        }
        return "无法匹配的类型";
    }
    public Integer getType() {
        return type;
    }
    public String getTypeDes() {
        return typeDes;
    }
}
