package com.bizvane.utils.enumutils;


public enum IntegralMallDeliveryEnum {
    DELIVERY_NOT_CONFIG(0, "无需配置"),
    DELIVERY_LOGISTICS(1, "物流配送"),
    DELIVERY_PICK_STORE(2, "到店自提"),
    DELIVERY_CUSTOMER_CHOICE(3, "客户自选");
    private final Integer type;
    private final String typeDes;
    IntegralMallDeliveryEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
    public static String getDescriptionByType(Integer type) {
        for (IntegralMallDeliveryEnum deliveryEnum : IntegralMallDeliveryEnum.values()) {
            if (deliveryEnum.getType().equals(type)) {
                return deliveryEnum.getTypeDes();
            }
        }
        return "无法匹配的类型";
    }
    public Integer getType() {
        return type;
    }
    public String getTypeDes() {
        return typeDes;
    }
}
