package com.bizvane.autoconfig.traceController;

import java.time.Duration;
import java.util.List;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 
 * @author wang.zeyan
 * @date 2018年9月3日
 *
 */
@ConfigurationProperties(prefix = "bizvane.trace.controller")
public class TraceControllerProperties {
	
	/**
	 * 是否开启
	 */
	private boolean enabled = true;

	private boolean audit = false;
	
	/**
	 * 跳过的方法名
	 */
	private String skipPattern = "";
	
	/**
	 * 日志name, default current class
	 */
	private String loggerName;
	
	/**
	 * 输出headers
	 */
	private boolean outRequestHeader = false;
	
	/**
	 * 输出header指定的名称列表
	 */
	private List<String> outRequestHeaderNames;
	
	/**
	 * 输出query
	 */
	private boolean outRequestQuery = true;
	
	/**
	 * 输出form
	 */
	private boolean outRequestForm = true;
	
	/**
	 * 输出requestBody
	 */
	private boolean outRequestBody = true;
	
	/**
	 * 输出执行结果
	 */
	private boolean outResponseResult = true;
	
	/**
	 * 输出结果最大长度
	 */
	private int outResponseMaxLength = 200;
	
	/**
	 * 慢请求阀值
	 */
	private Duration slowThreshold;

	public boolean isEnabled() {
		return enabled;
	}

	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}

	public String getSkipPattern() {
		return skipPattern;
	}

	public void setSkipPattern(String skipPattern) {
		this.skipPattern = skipPattern;
	}

	public String getLoggerName() {
		return loggerName;
	}

	public void setLoggerName(String loggerName) {
		this.loggerName = loggerName;
	}

	public boolean isOutRequestHeader() {
		return outRequestHeader;
	}

	public void setOutRequestHeader(boolean outRequestHeader) {
		this.outRequestHeader = outRequestHeader;
	}

	public List<String> getOutRequestHeaderNames() {
		return outRequestHeaderNames;
	}

	public void setOutRequestHeaderNames(List<String> outRequestHeaderNames) {
		this.outRequestHeaderNames = outRequestHeaderNames;
	}

	public boolean isOutRequestQuery() {
		return outRequestQuery;
	}

	public void setOutRequestQuery(boolean outRequestQuery) {
		this.outRequestQuery = outRequestQuery;
	}

	public boolean isOutRequestForm() {
		return outRequestForm;
	}

	public void setOutRequestForm(boolean outRequestForm) {
		this.outRequestForm = outRequestForm;
	}

	public boolean isOutRequestBody() {
		return outRequestBody;
	}

	public void setOutRequestBody(boolean outRequestBody) {
		this.outRequestBody = outRequestBody;
	}

	public boolean isOutResponseResult() {
		return outResponseResult;
	}

	public void setOutResponseResult(boolean outResponseResult) {
		this.outResponseResult = outResponseResult;
	}

	public int getOutResponseMaxLength() {
		return outResponseMaxLength;
	}

	public void setOutResponseMaxLength(int outResponseMaxLength) {
		this.outResponseMaxLength = outResponseMaxLength;
	}

	public Duration getSlowThreshold() {
		return slowThreshold;
	}

	public void setSlowThreshold(Duration slowThreshold) {
		this.slowThreshold = slowThreshold;
	}

	public boolean isAudit() {
		return audit;
	}

	public void setAudit(boolean audit) {
		this.audit = audit;
	}

}
