package com.bizvane.utils.vedioutils;

import lombok.extern.slf4j.Slf4j;
import lx.jave.Encoder;
import lx.jave.EncoderException;
import lx.jave.MultimediaInfo;

import java.io.File;

/**
 * @author chen.li
 * @date on 2019/11/22 15:17
 * @description 视频处理工具
 */
@Slf4j
public class VedioUtil {

    /**
     * 通过视频url获取视频长度
     * @param url
     * @return
     */
    public static long getVideoDuration(String url) {
        Encoder encoder = new Encoder();
        File file = new File(url);
        // 多媒体信息
        MultimediaInfo info = null;
        try {
            info = encoder.getInfo(file);
            // 时长信息
            return info.getDuration();
        } catch (EncoderException e) {
           log.error("VedioUtil#getVideoDuration"+e.getMessage());
        }
      return 0L;
    }
}
