package com.bizvane.utils.enumutils;

public enum PayChannelTypeEnum {
    /**
     * 微信支付通道
     */
    WECHAT_PAY("WEIXIN_TYPE", "微信支付通道"),

    /**
     * 工商银行支付通道
     */
    ICBC_PAY("ICBC_TYPE", "工商银行支付通道");

    /**
     * 枚举值
     */
    private String code;

    /**
     * 描述
     */
    private String description;

    PayChannelTypeEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public static PayChannelTypeEnum fromCode(String code) {
        for (PayChannelTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        throw new IllegalArgumentException("Unknown PayTypeEnum code: " + code);
    }
}

