/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.rocketutils;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.bizvane.utils.rocketutils.RocketMQProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RocketMQClient {
    @Autowired
    RocketMQProvider rocketMQProvider;

    public SendResult sendMessage(Message message) {
        SendResult sendResult = this.rocketMQProvider.getProducer().send(message);
        return sendResult;
    }

    public SendResult sendMessage(String messageBody, String topic, String tag, String megID, String messageKey) {
        Message message = new Message();
        message.setMsgID(megID);
        message.setKey(messageKey);
        message.setTag(tag);
        message.setTopic(topic);
        message.setBody(messageBody.getBytes());
        SendResult sendResult = this.rocketMQProvider.getProducer().send(message);
        return sendResult;
    }

    public SendResult sendMessage(String messageBody, String topic, String tag) {
        Message message = new Message();
        message.setTag(tag);
        message.setTopic(topic);
        message.setBody(messageBody.getBytes());
        SendResult sendResult = this.rocketMQProvider.getProducer().send(message);
        return sendResult;
    }

    public SendResult sendDeliverTimeMessage(String messageBody, String topic, String tag, long timeStamp) {
        Message message = new Message();
        message.setTag(tag);
        message.setTopic(topic);
        message.setBody(messageBody.getBytes());
        message.setStartDeliverTime(timeStamp);
        SendResult sendResult = this.rocketMQProvider.getProducer().send(message);
        return sendResult;
    }

    public SendResult sendDelayMessage(String messageBody, String topic, String tag, long timeStamp) {
        long delayTime = System.currentTimeMillis() + timeStamp;
        Message message = new Message();
        message.setTag(tag);
        message.setTopic(topic);
        message.setBody(messageBody.getBytes());
        message.setStartDeliverTime(delayTime);
        SendResult sendResult = this.rocketMQProvider.getProducer().send(message);
        return sendResult;
    }
}

