package com.bizvane.centercontrolservice.rpc;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/defRoleMenuRelRpc")
public interface DefRoleMenuRelServiceRpc {
    /**
     * 根据角色模板id查询角色模板菜单
     *
     * @param defRoleId
     * @return
     */
    @RequestMapping("/getDefRoleMenuList")
    List<Long> getDefRoleMenuList(@RequestParam("defRoleId") Long defRoleId);

    /**
     * 查询超级管理员菜单列表
     * @return
     */
    @RequestMapping("/getAdminMenuList")
    List<Long> getAdminMenuList();
}
