package com.bizvane.centercontrolservice.models.enums;

public enum FusionPayTypeEnum {

    WXPAY("wxpay","微信支付"),
    ALIPAY("alipay","支付宝")
    ;

    private String code;

    private String msg;

    FusionPayTypeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static String getCode(String code) {
        for (FusionPayTypeEnum value : FusionPayTypeEnum.values()) {
            if (value.code.equals(code)) {
                return value.getCode();
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
