package com.bizvane.centercontrolservice.interfaces;

import com.bizvane.centercontrolservice.models.po.VirtualCardBalancePo;
import com.bizvane.centercontrolservice.models.po.VirtualCardPo;
import com.bizvane.centercontrolservice.models.po.VirtualCardRecordPo;
import com.bizvane.centercontrolservice.models.rpc.VirtualCardRecordDetailExcel;
import com.bizvane.centercontrolservice.models.vo.VirtualCardRecordVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * @author xugy
 * @date on 2021-02-08
 * @description 虚拟卡券余额明细
 * @Copyright (c) 2021 上海商帆信息科技有限公司-版权所有
 */

public interface VirtualCardRecordService {

    /**
     * 添加虚拟卡券余额明细
     *
     * @param po
     * @return
     */
    ResponseData<Long> addVirtucalCardRecord(VirtualCardRecordPo po);

    /**
     * 查询企业卡券余额明细
     * @param vo
     * @return
     */
    ResponseData<PageInfo<VirtualCardRecordPo>> getVirtualCardRecordList(VirtualCardRecordVo vo);

    /**
     * 查询企业卡券余额明细
     * @param vo
     * @return
     */
    List<VirtualCardRecordPo> getCompanyVirtualCardRecordList(Long sysCompanyId);

    /**
     * 导出企业对账明细
     * @param vo
     * @return
     */
    List<VirtualCardRecordDetailExcel> exportVirtualCardRecordDetail(VirtualCardRecordVo vo);


    /**
     * 获取最后一条对账明细
     * @param sysCompanyId
     * @return
     */
    VirtualCardRecordPo getLastVirtualCardRecordPo(Long sysCompanyId);

}
