package com.bizvane.centercontrolservice.interfaces;

import com.bizvane.centercontrolservice.models.bo.AppletFunctionBO;
import com.bizvane.centercontrolservice.models.po.AppletFunctionPO;
import com.bizvane.centercontrolservice.models.vo.AppletFunctionVO;
import com.bizvane.centercontrolservice.utils.PageFormUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.CtrlAccountPO;

/**
 * Created by Geng on 2018/8/24.
 */
public interface AppletRouteConfigService {
    /**
     * 新增菜单配置
     * @param appletFunctionPo
     * @param ctrlAccountPo
     * @return
     */
    ResponseData saveAppletFunction(AppletFunctionBO appletFunctionPo, CtrlAccountPO ctrlAccountPo);

    /**
     * 展示功能菜单
     * @param pageFormUtil
     * @param appletRouteVO
     * @return
     */
    public ResponseData showAppletFunction(PageFormUtil pageFormUtil, AppletFunctionVO appletRouteVO);

    /**
     * 更新小程序路由配置
     * @param appletFunctionPo
     * @return
     */
    public ResponseData updateAppletFunction(AppletFunctionBO appletFunctionPo,CtrlAccountPO ctrlAccountPo);

    /**
     * id  删除小程序路由配置
     * @param appletFunctionPo
     * @return
     */
    public ResponseData deleteAppletFunction(AppletFunctionPO appletFunctionPo,CtrlAccountPO ctrlAccountPo);

    /**
     * 查看某路由配置详情
     * @param appletFunctionId
     * @return
     */
    public ResponseData getAppletFunctionById(Long appletFunctionId);

    /**
     * 启用或禁用功能菜单
     * @param appletFunctionPo
     * @param ctrlAccountPo
     * @return
     */
    public ResponseData stopOrStartAppletFunctionById(AppletFunctionPO appletFunctionPo,CtrlAccountPO ctrlAccountPo);



//    /**
//     * 保存小程序路由配置
//     * @param appletRoutePO
//     * @return
//     */
//    public ResponseData saveAppletRoute(AppletRoutePO appletRoutePO, CtrlAccountPO ctrlAccountPO);
//
//    /**
//     * 展示所有路由
//     * @return
//     */
//    public ResponseData showAppletRoute(PageFormUtil pageFormUtil,AppletRouteVO appletRouteVO);
//
//    /**
//     * 更新小程序路由
//     * @param appletRoutePO
//     * @return
//     */
//    public ResponseData updateAppletRoute(AppletRoutePO appletRoutePO);
//
//    /**
//     * 删除路由配置
//     * @return
//     */
//    public ResponseData deleteAppletRoute(AppletRoutePO appletRoutePO,CtrlAccountPO ctrlAccountPO);
//
//    /**
//     * 展示详情
//     * @param appletRouteId
//     * @return
//     */
//    public ResponseData getAppletRouteById(Long appletRouteId);
//
//
//    /**
//     * 启用/禁用小程序路由
//     * @param appletRoutePO
//     * @return
//     */
//    public ResponseData stopOrStartAppletRouteById(AppletRoutePO appletRoutePO,CtrlAccountPO ctrlAccountPO);

}
