package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.po.SysDictPo;
import com.bizvane.centercontrolservice.models.po.SysDictTypePo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/sysDictRpc")
public interface SysDictServiceRpc {

    /**
     * 查询所有词典type
     */
    @ResponseBody
    @PostMapping(value = "/getAllDictType")
    List<SysDictTypePo> getAllDictType();

    /**
     * 根据词典type查询
     */
    @ResponseBody
    @PostMapping(value = "/getDictByDictType")
    List<SysDictPo> getDictByDictType(@RequestParam("dictType") String dictType);
}
