package com.bizvane.cdp.algorithm.facade.interfaces.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class CdpMarketingModuleRecordSaveReqVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @NotNull(groups = BatchSave.class, message = "企业ID为空")
    @ApiModelProperty(value = "归属企业", name = "sysCompanyId")
    private Long sysCompanyId;

    @NotNull(groups = BatchSave.class, message = "品牌ID为空")
    @ApiModelProperty(value = "归属品牌", name = "sysBrandId")
    private Long sysBrandId;

    @NotBlank(groups = BatchSave.class, message = "营销编号为空")
    @ApiModelProperty(value = "营销编号", name = "marketingCode")
    private String marketingCode;

    @NotBlank(groups = BatchSave.class, message = "版本code为空")
    @ApiModelProperty(value = "版本code", name = "versionCode")
    private String versionCode;

    @NotBlank(groups = BatchSave.class, message = "组件类型为空")
    @ApiModelProperty(value = "组件类型", name = "moduleType")
    private String moduleType;

    @NotBlank(groups = BatchSave.class, message = "组件code为空")
    @ApiModelProperty(value = "组件code", name = "moduleCode")
    private String moduleCode;

    @NotBlank(groups = BatchSave.class, message = "批次号为空")
    @ApiModelProperty(value = "批次号", name = "batchNumber")
    private String batchNumber;

    @ApiModelProperty(value = "调度执行时间", name = "scheduleExecuteTime")
    private Date scheduleExecuteTime;

    @ApiModelProperty(value = "调度执行状态（0未执行 1已执行 2不执行）", name = "scheduleExecuteStatus")
    private Byte scheduleExecuteStatus;

    @ApiModelProperty(value = "批次状态（1有效 0无效）", name = "status")
    private Boolean status;

    @NotEmpty(groups = BatchSave.class, message = "bizOneIdList为空")
    @ApiModelProperty(value = "bizOneIdList", name = "bizOneIdList")
    private List<String> bizOneIdList;

    public interface BatchSave {}

}