package com.bizvane.cdp.algorithm.facade.interfaces.model;

import com.bizvane.cdp.facade.model.req.AddOrModifyEventConversionAbilityReqVO;
import com.bizvane.cdp.facade.model.rsp.AddOrModifyEventConversionRespVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.cdp-algorithm.name}", path = "${feign.client.cdp-algorithm.path}/eventConversion")
@Api(value = "事件转化", tags = {"事件转化"})
public interface CdpEventConversionFeign {

    @PostMapping("/queryList")
    ResponseData<AddOrModifyEventConversionRespVO> queryList(@RequestBody AddOrModifyEventConversionAbilityReqVO reqVO);

    @PostMapping("/queryFunnelChart")
    ResponseData<AddOrModifyEventConversionRespVO> queryFunnelChart(@RequestBody AddOrModifyEventConversionAbilityReqVO reqVO);

    @PostMapping("/queryHistogramChart")
    ResponseData<AddOrModifyEventConversionRespVO> queryHistogramChart(@RequestBody AddOrModifyEventConversionAbilityReqVO reqVO);

    @PostMapping("/queryLineChart")
    ResponseData<AddOrModifyEventConversionRespVO> queryLineChart(@RequestBody AddOrModifyEventConversionAbilityReqVO reqVO);

}
