package com.bizvane.cdp.algorithm.facade.interfaces;

import com.bizvane.cdp.algorithm.facade.interfaces.model.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;

@FeignClient(value = "${feign.client.cdp-algorithm.name}", path = "${feign.client.cdp-algorithm.path}")
@Api(value = "获取计算结果集", tags = {"获取计算结果集"})
public interface CdpAlgorithmGetDataFeign {

    @ApiOperation(value = "获取分群会员列表")
    @RequestMapping(value = "getData/getGroupMemberList", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<List<CdpAlgorithmGroupMemberListResponse>> getGroupMemberList(@Valid @RequestBody CdpAlgorithmGroupMemberListRequest request);


    @ApiOperation(value = "根据客户唯一ID获取会员信息列表")
    @RequestMapping(value = "getData/getMemberListById", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<List<QueryAlgorithmMemberListRspVO>> getMemberListById(@Valid @RequestBody  QueryAlgorithmMemberListReqVO request);


    @ApiOperation(value = "根据客户唯一ID获取会员动态信息列表")
    @RequestMapping(value = "getData/getDynamicMemberListById", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<List<Map<String, Object>>> getDynamicMemberListById(@Valid @RequestBody QueryAlgorithmDynamicMemberListReqVO request);
}
