package com.bizvane.cdp.algorithm.facade.interfaces.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@Data
public class CdpMarketingReachRecordSaveReqVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @NotNull(groups = BatchSave.class, message = "企业ID为空")
    @ApiModelProperty(value = "归属企业", name = "sysCompanyId")
    private Long sysCompanyId;

    @NotNull(groups = BatchSave.class, message = "品牌ID为空")
    @ApiModelProperty(value = "归属品牌", name = "sysBrandId")
    private Long sysBrandId;

    @NotBlank(groups = BatchSave.class, message = "营销编号为空")
    @ApiModelProperty(value = "营销编号", name = "marketingCode")
    private String marketingCode;

    @NotBlank(groups = BatchSave.class, message = "版本code为空")
    @ApiModelProperty(value = "版本code", name = "versionCode")
    private String versionCode;

    @NotBlank(groups = BatchSave.class, message = "组件类型为空")
    @ApiModelProperty(value = "组件类型", name = "moduleType")
    private String moduleType;

    @NotBlank(groups = BatchSave.class, message = "组件code为空")
    @ApiModelProperty(value = "组件code", name = "moduleCode")
    private String moduleCode;

    @NotBlank(groups = BatchSave.class, message = "批次号为空")
    @ApiModelProperty(value = "批次号", name = "batchNumber")
    private String batchNumber;

    @NotBlank(groups = BatchSave.class, message = "bizOneId为空")
    @ApiModelProperty(value = "biz_one_id",name = "bizOneId")
    private String bizOneId;

    @NotBlank(groups = BatchSave.class, message = "businessNo为空")
    @ApiModelProperty(value = "业务标识(优惠券定义ID, 短信模板code)",name = "businessNo")
    private String businessNo;

    @NotBlank(groups = BatchSave.class, message = "businessUniqueNo为空")
    @ApiModelProperty(value = "业务调用唯一标识符(优惠券定义ID, 短信模板code)_索引",name = "businessUniqueNo")
    private String businessUniqueNo;

    @ApiModelProperty(value = "发送时间",name = "sendTime")
    private Date sendTime;

    @ApiModelProperty(value = "发送调用状态，0未调用发送, 1调用发送成功, 2调用发送失败",name = "sendState")
    private Integer sendState;

    @ApiModelProperty(value = "发送调用情况描述",name = "sendStateReson")
    private String sendStateReson;

    @ApiModelProperty(value = "入参信息",name = "sendRequest")
    private String sendRequest;

    @ApiModelProperty(value = "响应信息",name = "sendResponse")
    private String sendResponse;

    @NotBlank(groups = BatchSave.class, message = "eventTable为空")
    @ApiModelProperty(value = "回收事件表",name = "eventTable")
    private String eventTable;


    public interface BatchSave {}

}