package com.bizvane.cdp.algorithm.facade.interfaces.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class QueryAlgorithmDynamicMemberListReqVO implements Serializable {

    private static final long serialVersionUID = 2523233285014857989L;
    @NotNull(message = "企业ID为空")
    @ApiModelProperty(value = "企业ID")
    private Long sysCompanyId;

    @NotNull(message = "品牌ID为空")
    @ApiModelProperty(value = "品牌ID")
    private Long sysBrandId;

    @ApiModelProperty(value = "客户唯一ID集合")
    @NotEmpty(message = "客户唯一ID集合为空")
    private List<String> bizOneIdList;

    @ApiModelProperty(value = "动态字段结果集合")
    @NotEmpty(message = "返回结果字段集合为空")
    private Set<DynamicColumnBo> dynamicColumnBoList;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class DynamicColumnBo{

        @ApiModelProperty(value = "动态字段，例如biz_one_id")
        private String dynamicColumn;

        @ApiModelProperty(value = "动态属性，例如bizOneId")
        private String dynamicProperty;

    }


}
