package com.bizvane.cdp.algorithm.facade.interfaces.util;

import cn.hutool.core.util.ObjUtil;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.cdp.facade.scheme.business.EventAnalysisAbilityConfig;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class CdpUtils {

    public static EventAnalysisAbilityConfig.EventTimeRange getRealTimeRange(EventAnalysisAbilityConfig.StatisticTimeRange statisticTimeRange) {
        // 时间统计列
        Integer eventTimeRelationType = statisticTimeRange.getEventTimeRelationType();
        String startTime, endTime;
        if (ObjUtil.equals(eventTimeRelationType, 1)) {
            startTime = statisticTimeRange.getEventTimeRange().getStartTime();
            endTime = statisticTimeRange.getEventTimeRange().getEndTime();
        } else {
            startTime = getStartTimeByStartType(JSONObject.parseObject(JSONObject.toJSONString(statisticTimeRange)));
            endTime = getEndTimeByEndType(JSONObject.parseObject(JSONObject.toJSONString(statisticTimeRange)));
        }
        EventAnalysisAbilityConfig.EventTimeRange eventTimeRange = new EventAnalysisAbilityConfig.EventTimeRange();
        eventTimeRange.setStartTime(startTime);
        eventTimeRange.setEndTime(endTime);
        return eventTimeRange;
    }

    public static String getStartTimeByStartType(JSONObject jsonObject) {
        JSONObject eventTimeRelative = jsonObject.getJSONObject("eventTimeRelative");
        Integer eventTimeRelativeStartType = eventTimeRelative.getInteger("eventTimeRelativeStartType");
        String eventTimeRelativeStartDate = eventTimeRelative.getString("eventTimeRelativeStartDate");
        String eventTimeRelativeStartTime = eventTimeRelative.getString("eventTimeRelativeStartTime");
        Integer eventTimeRelativeStartNum = eventTimeRelative.getInteger("eventTimeRelativeStartNum");
        String startTime = "";
        if (ObjUtil.equals(eventTimeRelativeStartType, 1)) {
            startTime = eventTimeRelativeStartDate + " " + eventTimeRelativeStartTime;
        } else if (ObjUtil.equals(eventTimeRelativeStartType, 2)) {
            startTime = LocalDateTime.now().minusDays(eventTimeRelativeStartNum).format(DateTimeFormatter.ofPattern("yyyy-MM-dd 00:00:00"));
        }
        return startTime;
    }

    public static String getEndTimeByEndType(JSONObject jsonObject) {
        JSONObject eventTimeRelative = jsonObject.getJSONObject("eventTimeRelative");
        Integer eventTimeRelativeEndType = eventTimeRelative.getInteger("eventTimeRelativeEndType");
        Integer eventTimeRelativeEndNum = eventTimeRelative.getInteger("eventTimeRelativeEndNum");
        String eventTimeRelativeEndTime = eventTimeRelative.getString("eventTimeRelativeEndTime");
        DateTimeFormatter endDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String endTime = "";
        // 结束时间类型 1-N天前 2-昨日 3-今日
        if (ObjUtil.equals(eventTimeRelativeEndType, 1)) {
            endTime = LocalDateTime.now().minusDays(eventTimeRelativeEndNum).format(endDateTimeFormatter);
        } else if (ObjUtil.equals(eventTimeRelativeEndType, 2)) {
            endTime = LocalDateTime.now().minusDays(1).format(endDateTimeFormatter);
        } else {
            endTime = LocalDateTime.now().format(endDateTimeFormatter);
        }
        endTime = endTime + " " + eventTimeRelativeEndTime;
        return endTime;
    }
}
