package com.bizvane.cdp.algorithm.facade.interfaces.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class CdpMarketingReachStatisticsReqVO implements Serializable {

    private static final long serialVersionUID = -7409299341700965119L;

    @NotNull(message = "企业ID为空")
    @ApiModelProperty(value = "企业ID")
    private Long sysCompanyId;

    @NotNull(message = "品牌ID为空")
    @ApiModelProperty(value = "品牌ID")
    private Long sysBrandId;

    @NotBlank(message = "组件类型为空")
    @ApiModelProperty(value = "组件类型")
    private String moduleType;

    @NotNull(message = "调用时间为空")
    @ApiModelProperty(value = "调用时间")
    private Date executeTime;

    @NotBlank(message = "事件表名为空")
    @ApiModelProperty(value = "事件表名")
    private String eventTable;

    @NotEmpty(message = "回收信息为空")
    @ApiModelProperty(value = "回收信息")
    private List<CdpMarketingReachStatisticsReqVO.ReachModuleEventRelation> reachModuleEventRelationList;

    @Data
    public static class ReachModuleEventRelation implements Serializable{
        private static final long serialVersionUID = 2783017114515431236L;

        @NotNull(message = "画布结果类型为空")
        @ApiModelProperty(value = "画布结果类型")
        private Integer branchType;

        @ApiModelProperty(value = "回收事件字段值")
        private String eventTableFieldValue;

    }

    @NotEmpty(message = "触达组件集合为空")
    @ApiModelProperty(value = "触达组件集合")
    private List<CdpMarketingReachStatisticsReqVO.ReachModule> reachModuleList;

    @Data
    public static class ReachModule implements Serializable{
        private static final long serialVersionUID = 7192223110865868412L;

        @NotNull(message = "企业ID为空")
        @ApiModelProperty(value = "企业ID")
        private Long sysCompanyId;

        @NotNull(message = "品牌ID为空")
        @ApiModelProperty(value = "品牌ID")
        private Long sysBrandId;

        @NotBlank(message = "营销编号为空")
        @ApiModelProperty(value = "营销编号")
        private String marketingCode;

        @NotBlank(message = "版本编号为空")
        @ApiModelProperty(value = "版本编号")
        private String versionCode;

        @NotBlank(message = "组件类型为空")
        @ApiModelProperty(value = "组件类型")
        private String moduleType;

        @NotBlank(message = "组件编号为空")
        @ApiModelProperty(value = "组件编号")
        private String moduleCode;

    }
}
