package com.bizvane.cdp.algorithm.facade.interfaces;

import com.bizvane.cdp.algorithm.facade.interfaces.model.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@FeignClient(value = "${feign.client.cdp-algorithm.name}", path = "${feign.client.cdp-algorithm.path}")
@Api(value = "执行计算任务", tags = {"执行计算任务"})
public interface CdpAlgorithmExecuteFeign {

    @ApiOperation(value = "计算标签")
    @RequestMapping(value = "execute/label", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<Boolean> executeLabel(@RequestBody CdpAlgorithmExecuteLabelRequest request);

    @ApiOperation(value = "计算人群")
    @RequestMapping(value = "execute/group", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<Boolean> executeGroup(@RequestBody CdpAlgorithmExecuteGroupRequest request);


    @ApiOperation(value = "营销计算人群")
    @RequestMapping(value = "execute/marketing", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<Boolean> executeMarketing(@RequestBody CdpAlgorithmExecuteMarketingReqVO request);

    @ApiOperation(value = "导入计算标签")
    @RequestMapping(value = "execute/labelForImport", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<Boolean> executeLabelForImport(@RequestBody CdpAlgorithmExecuteLabelForImportReqVO request);

    @ApiOperation(value = "导入计算人群")
    @RequestMapping(value = "execute/groupForImport", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<Boolean> executeGroupForImport(@RequestBody CdpAlgorithmExecuteGroupForImportReqVO request);

    @ApiOperation(value = "保存从营销某个节点进入的人群至客户分群")
    @RequestMapping(value = "execute/saveCustomerGroupForMarketingProcessNode", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<Boolean> saveCustomerGroupForMarketingProcessNode(@RequestBody CdpCustomerGroupSaveRequestVO request);


    @ApiOperation(value = "营销延迟组件调度")
    @RequestMapping(value = "execute/marketingDelay", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<Boolean> executeMarketingDelay(@RequestBody CdpAlgorithmExecuteMarketingDelayReqVO request);

    @ApiOperation(value = "事件判断组件保存记录")
    @RequestMapping(value = "execute/saveEventEstimateRecord", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<Boolean> saveEventEstimateRecord(@RequestBody CdpAlgorithmExecuteEventEstimateReqVO request);

    @ApiOperation(value = "事件判断组件执行")
    @RequestMapping(value = "execute/executeEventEstimate", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<Boolean> executeEventEstimate(@RequestBody CdpAlgorithmExecuteEventEstimateReqVO request);
}
