package com.bizvane.cdp.algorithm.facade.interfaces;

import com.bizvane.cdp.algorithm.facade.interfaces.model.CdpMarketingModuleRecordSaveReqVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@FeignClient(value = "${feign.client.cdp-algorithm.name}", path = "${feign.client.cdp-algorithm.path}")
@Api(value = "CDP自动营销客户组件记录", tags = {"CDP自动营销客户组件记录"})
public interface CdpMarketingModuleRecordFeign {

    @ApiOperation(value = "记录保存(支持批量)")
    @RequestMapping(value = "marketing/saveRecord", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<Integer> saveRecord(@RequestBody CdpMarketingModuleRecordSaveReqVo request);

}
