/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.tools.logging;

import com.p6spy.engine.logging.Category;
import com.p6spy.engine.spy.appender.FormattedLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4JLogger
extends FormattedLogger {
    private Logger log = LoggerFactory.getLogger((String)"com.bizvane.tools.sqlLog");

    public void logException(Exception e) {
        this.log.info("", (Throwable)e);
    }

    public void logText(String text) {
        this.log.info(text);
    }

    public void logSQL(int connectionId, String now, long elapsed, Category category, String prepared, String sql, String url) {
        sql = sql.replaceAll("\\n", "");
        String msg = this.strategy.formatMessage(connectionId, now, elapsed, category.toString(), prepared, sql, url);
        if (Category.ERROR.equals((Object)category) || Category.OUTAGE.equals((Object)category)) {
            this.log.error(msg);
        } else if (Category.WARN.equals((Object)category)) {
            this.log.warn(msg);
        } else if (Category.DEBUG.equals((Object)category)) {
            this.log.debug(msg);
        } else {
            this.log.info(msg);
        }
    }

    public boolean isCategoryEnabled(Category category) {
        if (Category.ERROR.equals((Object)category)) {
            return this.log.isErrorEnabled();
        }
        if (Category.WARN.equals((Object)category)) {
            return this.log.isWarnEnabled();
        }
        if (Category.DEBUG.equals((Object)category)) {
            return this.log.isDebugEnabled();
        }
        return this.log.isInfoEnabled();
    }
}

