/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.IntegralConfig;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.mapper.IntegralConfigMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersMapper;
import com.wmeimob.fastboot.bizvane.service.CommonIntegralOrdersService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class CommonIntegralOrdersServiceImpl
implements CommonIntegralOrdersService {
    private static final Logger log = LoggerFactory.getLogger(CommonIntegralOrdersServiceImpl.class);
    @Autowired
    private IntegralOrdersMapper integralOrdersMapper;
    @Autowired
    private IntegralConfigMapper integralConfigMapper;
    @Autowired
    private IntegralGoodsMapper integralGoodsMapper;

    @Override
    public void settle(Integer merchantId) {
        log.info("\u8bbe\u7f6e\u81ea\u52a8\u7b7e\u6536\u548c\u5173\u95ed");
        Example configExample = new Example(IntegralConfig.class);
        configExample.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        IntegralConfig config = (IntegralConfig)this.integralConfigMapper.selectOneByExample(configExample);
        if (config == null) {
            log.info("\u54c1\u724cid:{},\u65e0\u57fa\u672c\u914d\u7f6e\uff01", (Object)merchantId);
            return;
        }
        log.info("\u8bbe\u7f6e\u5df2\u53d1\u8d27\u8ba2\u5355\u81ea\u52a8\u7b7e\u6536");
        Example example = new Example(IntegralOrders.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("orderStatus", (Object)IntegralOrdersStatusEnum.SHIPPED.getCode()).andCondition("(UNIX_TIMESTAMP(SYSDATE())-UNIX_TIMESTAMP(send_good_time)) >", (Object)(config.getAwaitOrderDelivery() * 86400));
        List ordersList = this.integralOrdersMapper.selectByExample(example);
        for (IntegralOrders orders : ordersList) {
            orders.setOrderStatus(IntegralOrdersStatusEnum.SIGN.getCode());
            orders.setGmtModified(new Date());
            this.integralOrdersMapper.updateByPrimaryKeySelective(orders);
        }
        log.info("\u9700\u8981\u81ea\u52a8\u7b7e\u6536\u7684\u8ba2\u5355\u4e3a:{}", (Object)JSONObject.toJSONString((Object)ordersList));
        log.info("\u8bbe\u7f6e\u5df2\u7b7e\u6536\u8ba2\u5355\u81ea\u52a8\u5173\u95ed");
        Example signExample = new Example(IntegralOrders.class);
        signExample.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("valid", (Object)Boolean.TRUE).andEqualTo("orderStatus", (Object)IntegralOrdersStatusEnum.SIGN.getCode()).andCondition("(UNIX_TIMESTAMP(SYSDATE())-UNIX_TIMESTAMP(gmt_modified)) >", (Object)(config.getAwaitOrderReturnable() * 86400));
        List signOrdersList = this.integralOrdersMapper.selectByExample(signExample);
        for (IntegralOrders orders : signOrdersList) {
            orders.setOrderStatus(IntegralOrdersStatusEnum.CLOSE.getCode());
            orders.setGmtModified(new Date());
            this.integralOrdersMapper.updateByPrimaryKeySelective(orders);
        }
        log.info("\u9700\u8981\u81ea\u52a8\u5173\u95ed\u7684\u8ba2\u5355\u4e3a:{}", (Object)JSONObject.toJSONString((Object)signOrdersList));
    }

    @Override
    public List<Integer> getAllMerchantId() {
        return this.integralGoodsMapper.getAllMerchantId();
    }
}

