/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpec;
import com.wmeimob.fastboot.bizvane.entity.MallLogs;
import com.wmeimob.fastboot.bizvane.entity.OrderPayTypeVO;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.enums.GoodSpecEnum;
import com.wmeimob.fastboot.bizvane.enums.PushFlagEnum;
import com.wmeimob.fastboot.bizvane.event.RefundEvent;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.utils.StringUtil;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class RefundEventListener
implements ApplicationListener<RefundEvent> {
    private static final Logger log = LoggerFactory.getLogger(RefundEventListener.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Autowired
    private OrdersMapper ordersMapper;
    @Autowired
    private GoodsSpecMapper goodsSpecMapper;

    public void onApplicationEvent(RefundEvent refundEvent) {
        this.scheduledThreadPoolExecutor.execute(() -> {
            block5: {
                try {
                    log.info("RefundEventListener#onApplicationEvent orderEvent:{}", (Object)JSON.toJSONString((Object)((Object)refundEvent)));
                    RefundOrder refundOrder = refundEvent.getRefundOrder();
                    RefundOrder puRefund = new RefundOrder();
                    BeanUtils.copyProperties((Object)refundOrder, (Object)puRefund);
                    Integer pushFlag = refundEvent.getPushFlag();
                    if (pushFlag == null || !pushFlag.equals(PushFlagEnum.REFUND.getPushFlag()) || !puRefund.getRefundType().equals(1)) break block5;
                    log.info("RefundEventListener#onApplicationEvent#\u9000\u6b3e\u63a8\u9001\u7ebf\u4e0b\u4efb\u52a1:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)puRefund));
                    try {
                        Orders puOrders = new Orders();
                        puOrders.setOrderNo(refundOrder.getOrderNo());
                        puOrders = (Orders)this.ordersMapper.selectOne(puOrders);
                        log.info("RefundEventListener#onApplicationEvent#orders:{}", (Object)JSON.toJSONString((Object)puOrders));
                        if (puOrders != null) {
                            CompanyBrandRelation companyBrandRelation = new CompanyBrandRelation();
                            companyBrandRelation.setMerchantId(puOrders.getMerchantId());
                            companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne(companyBrandRelation);
                            puOrders.setSysCompanyId(companyBrandRelation.getCompanyId());
                            Object s = null;
                            MallLogs mallLogs = new MallLogs();
                            puOrders.getItems().forEach(e -> {
                                String[] split;
                                String specIds = e.getSpecIds();
                                String colorCode = null;
                                String sizeCode = null;
                                if (!StringUtils.isEmpty((Object)specIds) && (split = specIds.split(",")).length > 0) {
                                    for (int i = 0; i < split.length; ++i) {
                                        String id = split[0];
                                        GoodsSpec goodsSpec = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey(id);
                                        Integer pid = goodsSpec.getPid();
                                        if (pid == 0) continue;
                                        GoodsSpec parent = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey(pid);
                                        String specName = parent.getSpecName();
                                        if (GoodSpecEnum.COLOR.getName().equals(specName)) {
                                            colorCode = goodsSpec.getSpecCode();
                                        }
                                        if (!GoodSpecEnum.SIZE.getName().equals(specName)) continue;
                                        sizeCode = goodsSpec.getSpecCode();
                                    }
                                }
                                String specCodes = StringUtil.append(colorCode, sizeCode);
                                e.setSpecCode(specCodes);
                            });
                            ArrayList<OrderPayTypeVO> orderPayTypeVOS = new ArrayList<OrderPayTypeVO>();
                            OrderPayTypeVO build = OrderPayTypeVO.builder().payType(puOrders.getPayType()).payMoney(puOrders.getPayAmount()).build();
                            orderPayTypeVOS.add(build);
                            puOrders.setPayTypes(orderPayTypeVOS);
                            log.info("RefundEventListener#onApplicationEvent#\u5904\u7406\u5b8c\u6210\u8ba2\u5355\u6570\u636e:[{}]", JSON.toJSON((Object)puOrders));
                            this.bizvaneInterface.notifyPaidOrderInfoOffLine(puOrders);
                        }
                    }
                    catch (Exception e2) {
                        log.error("RefundEventListener#onApplicationEvent#\u9000\u6b3e\u63a8\u9001\u7ebf\u4e0b\u5931\u8d25:msg:[{}]_[{}]", (Object)e2.getMessage(), (Object)e2);
                    }
                }
                catch (Exception e3) {
                    log.error(e3.getMessage(), (Throwable)e3);
                }
            }
        });
        this.scheduledThreadPoolExecutor.execute(() -> {
            try {
                RefundOrder refundOrder = refundEvent.getRefundOrder();
                log.info("\u9000\u6b3e\u63a8\u9001\u4f01\u5fae");
                if (refundOrder != null) {
                    log.info("\u9000\u6b3e\u63a8\u9001\u4f01\u5fae\u4efb\u52a1:\u5165\u53c2:[{}]", JSONObject.toJSON((Object)refundOrder));
                    Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey(refundOrder.getItems().get(0).getGoodsId());
                    refundOrder.getItems().get(0).setGoodsNo(goods.getGoodsNo());
                    if (refundOrder.getRefundType().equals(1)) {
                        log.info("\u9000\u6b3e\u63a8\u9001\u4f01\u5fae\u4efb\u52a1\u4e8b\u4ef6\u76d1\u542c\u5f00\u59cb----------->");
                        this.bizvaneInterface.notifyRefundQW(refundEvent.getRefundOrder());
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
    }
}

