/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.utils.jobutils;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.utils.jobutils.JobClient;
import com.wmeimob.fastboot.bizvane.utils.jobutils.JobEnum;
import com.wmeimob.fastboot.bizvane.utils.jobutils.XxlJobInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"xxl.job.admin.addresses"})
@Component
public class XxlJobUtil {
    private static final Logger log = LoggerFactory.getLogger(XxlJobUtil.class);
    @Autowired
    private JobClient jobClient;

    public void addJob(Date execuDate, String desc, String param, String author, String jobHandler, int businessType, String bizCode, String appName) {
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setAppName(appName);
        xxlJobInfo.setExecutorRouteStrategy(JobEnum.EXECUTOR_ROUTE_STRATEGY_FIRST.getValue());
        xxlJobInfo.setJobCron(XxlJobUtil.getCronExpression(execuDate));
        xxlJobInfo.setGlueType(JobEnum.GLUE_TYPE_BEAN.getValue());
        xxlJobInfo.setExecutorHandler(jobHandler);
        xxlJobInfo.setJobDesc(desc);
        xxlJobInfo.setExecutorParam(param);
        xxlJobInfo.setExecutorBlockStrategy(JobEnum.EXECUTOR_BLOCK_SERIAL_EXECUTION.getValue());
        xxlJobInfo.setExecutorFailStrategy(JobEnum.EXECUTOR_FAIL_STRATEGY_NULL.getValue());
        xxlJobInfo.setAuthor(author);
        xxlJobInfo.setBizType(businessType);
        xxlJobInfo.setBizCode(bizCode);
        log.info("\u5b9a\u65f6\u4efb\u52a1\u521b\u5efa\u7ed3\u679c\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)xxlJobInfo));
        ResponseEntity<String> stringResponseEntity = this.jobClient.addJob(xxlJobInfo);
        log.info("\u5b9a\u65f6\u4efb\u52a1\u521b\u5efa\u7ed3\u679c :{}", stringResponseEntity);
    }

    public void addJob(String execuDateCron, String desc, String param, String author, String jobHandler, int businessType, String bizCode, String appName) {
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setAppName(appName);
        xxlJobInfo.setExecutorRouteStrategy(JobEnum.EXECUTOR_ROUTE_STRATEGY_FIRST.getValue());
        xxlJobInfo.setJobCron(execuDateCron);
        xxlJobInfo.setGlueType(JobEnum.GLUE_TYPE_BEAN.getValue());
        xxlJobInfo.setExecutorHandler(jobHandler);
        xxlJobInfo.setJobDesc(desc);
        xxlJobInfo.setExecutorParam(param);
        xxlJobInfo.setExecutorBlockStrategy(JobEnum.EXECUTOR_BLOCK_SERIAL_EXECUTION.getValue());
        xxlJobInfo.setExecutorFailStrategy(JobEnum.EXECUTOR_FAIL_STRATEGY_NULL.getValue());
        xxlJobInfo.setAuthor(author);
        xxlJobInfo.setBizType(businessType);
        xxlJobInfo.setBizCode(bizCode);
        ResponseEntity<String> stringResponseEntity = this.jobClient.addJob(xxlJobInfo);
        log.info("\u5b9a\u65f6\u4efb\u52a1\u521b\u5efa\u7ed3\u679c :{}", stringResponseEntity);
    }

    public void removeByBiz(int businessType, String bizCode) {
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setBizType(businessType);
        xxlJobInfo.setBizCode(bizCode);
        this.jobClient.removeByBiz(xxlJobInfo);
    }

    public static String getCronExpression(Date date) {
        String dateFormat = "ss mm HH dd MM ? yyyy";
        return XxlJobUtil.formatDateByPattern(date, dateFormat);
    }

    public static String formatDateByPattern(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }
}

