/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event.addorder.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.OrderActivityTypeEnum;
import com.wmeimob.fastboot.bizvane.po.MerchantOfflineConfigPO;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.SendErpOrderMsgRecordService;
import com.wmeimob.fastboot.bizvane.service.SendOrderMsgRecordService;
import com.wmeimob.fastboot.bizvane.service.config.MerchantOfflineConfigService;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MarketOrderAddEnterpriseListener {
    private static final Logger log = LoggerFactory.getLogger(MarketOrderAddEnterpriseListener.class);
    @Autowired
    private SendOrderMsgRecordService sendOrderMsgRecordService;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private MerchantOfflineConfigService merchantOfflineConfigService;
    @Autowired
    private SendErpOrderMsgRecordService sendErpOrderMsgRecordService;

    public void dispose(Orders orders) {
        log.info("MarketOrderAddEnterpriseListener#OrderAddEvent:{}", (Object)JSON.toJSONString((Object)orders));
        String orderNo = orders.getOrderNo();
        Integer merchantId = orders.getMerchantId();
        String ordersActivityType = orders.getOrdersActivityType();
        ArrayList<String> pushTypeList = new ArrayList<String>();
        pushTypeList.add(OrderActivityTypeEnum.KJ.getCode().toString());
        pushTypeList.add(OrderActivityTypeEnum.PIT.getCode().toString());
        pushTypeList.add(OrderActivityTypeEnum.MS.getCode().toString());
        pushTypeList.add(OrderActivityTypeEnum.YS.getCode().toString());
        pushTypeList.add(OrderActivityTypeEnum.CB.getCode().toString());
        HashMap<String, OrderActivityTypeEnum> orderActivityTypeEnumHashMap = new HashMap<String, OrderActivityTypeEnum>();
        OrderActivityTypeEnum[] values = OrderActivityTypeEnum.values();
        for (int i = 0; i < values.length; ++i) {
            OrderActivityTypeEnum value = values[i];
            String key = value.getCode().toString();
            orderActivityTypeEnumHashMap.put(key, value);
        }
        if (!pushTypeList.contains(ordersActivityType)) {
            OrderActivityTypeEnum orderActivityTypeEnum = (OrderActivityTypeEnum)((Object)orderActivityTypeEnumHashMap.get(ordersActivityType));
            log.info("MarketOrderAddEnterpriseListener#\u8ba2\u5355:{}\u7684\u7c7b\u578b\u4e3a:{},\u6682\u65f6\u4e0d\u63a8\u9001\u4f01\u5fae", (Object)orderNo, (Object)orderActivityTypeEnum.getDesc());
        } else {
            try {
                this.bizvaneInterface.notifyNewOrderInfoToQW(orders);
            }
            catch (Exception e) {
                log.error("\u652f\u4ed8\u6210\u529f\u8ba2\u5355\u63a8\u9001\u4f01\u5faeerror:{}", (Throwable)e);
            }
            try {
                log.info("\u5206\u4eab\u4e0b\u5355\u901a\u77e5\u4f01\u5fae");
                this.bizvaneInterface.notifyOrderInfoToQWFirst(orders);
            }
            catch (Exception e) {
                log.error("\u5206\u4eab\u4e0b\u5355\u901a\u77e5\u4f01\u5fae\u5931\u8d25:{}_{}", (Object)e.getMessage(), (Object)e);
            }
        }
        try {
            MerchantOfflineConfigPO config = this.merchantOfflineConfigService.findByMerchantId(merchantId);
            if (config != null) {
                log.info("MarketOrderAddEnterpriseListener#dispose\u65b9\u6cd5,\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record", (Object)orders.getOrderNo());
                this.sendOrderMsgRecordService.addOrderMsgRecord(merchantId, orders.getOrderNo(), orders);
                log.info("MarketOrderAddEnterpriseListener#dispose\u65b9\u6cd5,\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u4fe1\u606f:{}", (Object)orders.getOrderNo(), (Object)orders);
            } else {
                log.info("\u7ebf\u4e0b\u914d\u7f6e\u8868\u67e5\u8be2\u914d\u7f6e\u7a7a\uff0c\u4e0d\u8fdb\u5165\u63a8\u9001\u8bb0\u5f55\u8868merchantId=" + orders.getOrderNo());
            }
        }
        catch (Exception e) {
            log.error("MarketOrderAddEnterpriseListener#dispose\u65b9\u6cd5,\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u8868\u5931\u8d25", (Object)orders.getOrderNo());
        }
        try {
            log.info("\u8ba2\u5355:{},\u4fdd\u5b58t_send_erp_order_msg_record", (Object)orders.getOrderNo());
            Boolean addOrderMsgRecordFlag = this.sendErpOrderMsgRecordService.addOrderMsgRecord(merchantId, orders.getOrderNo(), orders);
            log.info("\u8ba2\u5355:{},\u4fdd\u5b58t_send_erp_order_msg_record\u4fe1\u606f\u7ed3\u679c:{}", (Object)orders.getOrderNo(), (Object)addOrderMsgRecordFlag);
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355:{},\u4fdd\u5b58t_send_erp_order_msg_record\u8868\u5931\u8d25,e:{}", (Object)orders.getOrderNo(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

