/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.baison.utils;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.baison.dto.requestVO.BaisonOrderDetailGetV2RequestVO;
import com.wmeimob.fastboot.baison.dto.requestVO.BaisonOrderListGetResponse;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonOrderDetailGetBusinessDataResponse;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonOrderDetailGetOrderListGetResponse;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonOrderDetailGetResponseVO;
import com.wmeimob.fastboot.baison.service.E3OrderService;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BaisonOrderUtil {
    private static final Logger log = LoggerFactory.getLogger(BaisonOrderUtil.class);
    @Autowired
    private E3OrderService e3OrderService;

    public BaisonOrderListGetResponse getE3OrderInfo(String orderNo) {
        log.info("===================\u6211\u65b9\u8ba2\u5355\u53f7=======" + orderNo);
        try {
            BaisonOrderDetailGetV2RequestVO requestVO = new BaisonOrderDetailGetV2RequestVO();
            requestVO.setDeal_code(orderNo);
            requestVO.setPageNo(1);
            requestVO.setPageSize(20);
            BaisonOrderDetailGetResponseVO getResponseVO = this.e3OrderService.orderDetailGetV2(requestVO);
            log.info("=============E3\u8fd4\u56de\u7684\u5168\u90e8\u6570\u636e:{}", (Object)JSON.toJSONString((Object)getResponseVO));
            BaisonOrderDetailGetBusinessDataResponse data = getResponseVO.getData();
            log.info("=============E3\u8fd4\u56de\u7684data\u6570\u636e:{}", (Object)JSON.toJSONString((Object)data));
            if (data != null) {
                Iterator<BaisonOrderDetailGetOrderListGetResponse> iterator;
                List<BaisonOrderDetailGetOrderListGetResponse> orderListGets = data.getOrderListGets();
                log.info("=============E3\u8fd4\u56de\u7684orderListGets\u6570\u636e:{}", (Object)JSON.toJSONString(orderListGets));
                if (CollectionUtils.isNotEmpty(orderListGets) && (iterator = orderListGets.iterator()).hasNext()) {
                    BaisonOrderDetailGetOrderListGetResponse o = iterator.next();
                    BaisonOrderListGetResponse orderListGet = o.getOrderListGet();
                    log.info("=============E3\u8fd4\u56de\u7684orderListGet\u6570\u636e:{}", (Object)JSON.toJSONString((Object)orderListGet));
                    return orderListGet;
                }
            }
        }
        catch (Exception e) {
            log.info("BaisonOrderUtil getE3OrderInfo \u6839\u636e\u6211\u65b9\u8ba2\u5355\u53f7\u5f97\u5230E3\u8ba2\u5355\u65f6\u5f02\u5e38:{}", (Object[])e.getStackTrace());
        }
        log.info("=============E3\u8fd4\u56de\u7684\u6570\u636e\u4e3anull==========");
        return null;
    }

    public String getE3OrderNo(String orderNo) {
        log.info("========getE3OrderNo===========\u6211\u65b9\u8ba2\u5355\u53f7=======" + orderNo);
        BaisonOrderListGetResponse e3OrderInfo = this.getE3OrderInfo(orderNo);
        if (e3OrderInfo != null) {
            log.info("E3\u8fd4\u56de\u7684e3OrderInfo\u6570\u636e:{}", (Object)JSON.toJSONString((Object)e3OrderInfo));
            String order_sn = e3OrderInfo.getOrder_sn();
            log.info("E3\u8fd4\u56de\u7684\u8ba2\u5355\u53f7:{}", (Object)order_sn);
            return order_sn;
        }
        log.info("=============E3\u8fd4\u56de\u7684\u8ba2\u5355\u53f7\u4e3anull==========");
        return null;
    }

    public String getE3OrderDealCode(String orderNo) {
        log.info("==========getE3OrderDealCode=========\u6211\u65b9\u8ba2\u5355\u53f7=======" + orderNo);
        BaisonOrderListGetResponse e3OrderInfo = this.getE3OrderInfo(orderNo);
        if (e3OrderInfo != null) {
            log.info("E3\u8fd4\u56de\u7684e3OrderInfo\u6570\u636e:{}", (Object)JSON.toJSONString((Object)e3OrderInfo));
            String deal_code = e3OrderInfo.getDeal_code();
            log.info("E3\u8fd4\u56de\u7684\u7f51\u5e97\u4ea4\u6613\u53f7\u53f7:{}", (Object)deal_code);
            return deal_code;
        }
        log.info("=============E3\u8fd4\u56de\u7684\u7f51\u5e97\u4ea4\u6613\u53f7\u4e3anull==========");
        return null;
    }
}

