/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.IntegralRefundOrder;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.enums.SendOrderMsgRecordRefundStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.SendOrderMsgRecordStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.SendOrderMsgRecordTypeEnum;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SendErpOrderMsgRecordPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPOExample;
import com.wmeimob.fastboot.bizvane.po.IntegralOrdersPO;
import com.wmeimob.fastboot.bizvane.po.SendErpOrderMsgRecordPO;
import com.wmeimob.fastboot.bizvane.po.SendErpOrderMsgRecordPOExample;
import com.wmeimob.fastboot.bizvane.service.SendErpOrderMsgRecordService;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SendErpOrderMsgRecordServiceImpl
implements SendErpOrderMsgRecordService {
    private static final Logger log = LoggerFactory.getLogger(SendErpOrderMsgRecordServiceImpl.class);
    @Resource
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Resource
    private SendErpOrderMsgRecordPOMapper sendErpOrderMsgRecordPOMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public Boolean addOrderMsgRecord(Integer merchantId, String orderNo, Orders orders) {
        String redisKey = "addOrderMsgRecord:" + merchantId + ":" + orderNo;
        if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)"1").booleanValue()) {
            log.warn("t_send_erp_order_msg_record\u8868\u5df2\u5b58\u5728\u8ba2\u5355:{}", (Object)orderNo);
            return Boolean.FALSE;
        }
        this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)"1", 5L, TimeUnit.MINUTES);
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<CompanyBrandRelationPO> companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        if (CollectionUtils.isEmpty(companyBrandRelationPOS)) {
            log.warn("\u5f53\u524d\u5546\u6237\u6ca1\u6709\u914d\u7f6ecompany_brand_relation\u8868");
            return Boolean.FALSE;
        }
        CompanyBrandRelationPO companyBrandRelationPO = companyBrandRelationPOS.get(0);
        SendErpOrderMsgRecordPOExample sendErpOrderMsgRecordPOExample = new SendErpOrderMsgRecordPOExample();
        sendErpOrderMsgRecordPOExample.createCriteria().andOrderNoEqualTo(orderNo).andTypeEqualTo(SendOrderMsgRecordTypeEnum.ORDER.getCode()).andValidEqualTo(Boolean.TRUE);
        List<SendErpOrderMsgRecordPO> sendErpOrderMsgRecordPOList = this.sendErpOrderMsgRecordPOMapper.selectByExample(sendErpOrderMsgRecordPOExample);
        if (!CollectionUtils.isEmpty(sendErpOrderMsgRecordPOList)) {
            log.warn("t_send_erp_order_msg_record\u8868\u5df2\u5b58\u5728\u8ba2\u5355:{}", (Object)orderNo);
            return Boolean.FALSE;
        }
        String traceId = MDC.get((String)"traceId");
        SendErpOrderMsgRecordPO sendErpOrderMsgRecordPO = new SendErpOrderMsgRecordPO();
        sendErpOrderMsgRecordPO.setMerchantId(merchantId);
        sendErpOrderMsgRecordPO.setSysBrandId(companyBrandRelationPO.getBrandId());
        sendErpOrderMsgRecordPO.setOrderNo(orderNo);
        sendErpOrderMsgRecordPO.setOrganizationCode(orders.getOrgCode());
        sendErpOrderMsgRecordPO.setJsonContent(JSON.toJSONString((Object)orders));
        sendErpOrderMsgRecordPO.setTrace(traceId);
        sendErpOrderMsgRecordPO.setType(SendOrderMsgRecordTypeEnum.ORDER.getCode());
        sendErpOrderMsgRecordPO.setStatus(SendOrderMsgRecordStatusEnum.CREATE.getCode());
        sendErpOrderMsgRecordPO.setGmtCreate(new Date());
        this.sendErpOrderMsgRecordPOMapper.insertSelective(sendErpOrderMsgRecordPO);
        log.info("\u5546\u57ce\u53d1\u9001\u8bb0\u5f55id:{}", (Object)sendErpOrderMsgRecordPO.getSendErpOrderMsgRecordId());
        return Boolean.TRUE;
    }

    @Override
    public Boolean addRefundOrderMsgRecord(Integer merchantId, String refundNo, RefundOrder refundOrder) {
        String redisKey = "addRefundOrderMsgRecord:" + merchantId + ":" + refundNo;
        if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)"1").booleanValue()) {
            log.warn("t_send_erp_order_msg_record\u8868\u5df2\u5b58\u5728\u9000\u5355:{}", (Object)refundNo);
            return Boolean.FALSE;
        }
        this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)"1", 5L, TimeUnit.MINUTES);
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<CompanyBrandRelationPO> companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        if (CollectionUtils.isEmpty(companyBrandRelationPOS)) {
            log.warn("\u5f53\u524d\u5546\u6237\u6ca1\u6709\u914d\u7f6ecompany_brand_relation\u8868");
            return Boolean.FALSE;
        }
        CompanyBrandRelationPO companyBrandRelationPO = companyBrandRelationPOS.get(0);
        SendErpOrderMsgRecordPOExample sendErpOrderMsgRecordPOExample = new SendErpOrderMsgRecordPOExample();
        sendErpOrderMsgRecordPOExample.createCriteria().andOrderNoEqualTo(refundNo).andTypeEqualTo(SendOrderMsgRecordTypeEnum.REFUND_ORDER.getCode()).andValidEqualTo(Boolean.TRUE);
        List<SendErpOrderMsgRecordPO> sendErpOrderMsgRecordPOList = this.sendErpOrderMsgRecordPOMapper.selectByExample(sendErpOrderMsgRecordPOExample);
        if (!CollectionUtils.isEmpty(sendErpOrderMsgRecordPOList)) {
            log.warn("t_send_erp_order_msg_record\u8868\u5df2\u5b58\u5728\u9000\u5355:{}", (Object)refundNo);
            return Boolean.FALSE;
        }
        String traceId = MDC.get((String)"traceId");
        SendErpOrderMsgRecordPO sendErpOrderMsgRecordPO = new SendErpOrderMsgRecordPO();
        sendErpOrderMsgRecordPO.setMerchantId(merchantId);
        sendErpOrderMsgRecordPO.setSysBrandId(companyBrandRelationPO.getBrandId());
        sendErpOrderMsgRecordPO.setOrderNo(refundNo);
        sendErpOrderMsgRecordPO.setJsonContent(JSON.toJSONString((Object)refundOrder));
        sendErpOrderMsgRecordPO.setTrace(traceId);
        sendErpOrderMsgRecordPO.setType(SendOrderMsgRecordTypeEnum.REFUND_ORDER.getCode());
        sendErpOrderMsgRecordPO.setStatus(SendOrderMsgRecordStatusEnum.CREATE.getCode());
        sendErpOrderMsgRecordPO.setGmtCreate(new Date());
        this.sendErpOrderMsgRecordPOMapper.insertSelective(sendErpOrderMsgRecordPO);
        log.info("\u5546\u57ce\u53d1\u9001\u8bb0\u5f55id:{}", (Object)sendErpOrderMsgRecordPO.getSendErpOrderMsgRecordId());
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateRefundOrderBegin(String refundNo) {
        SendErpOrderMsgRecordPOExample sendErpOrderMsgRecordPOExample = new SendErpOrderMsgRecordPOExample();
        sendErpOrderMsgRecordPOExample.createCriteria().andOrderNoEqualTo(refundNo).andTypeEqualTo(SendOrderMsgRecordTypeEnum.REFUND_ORDER.getCode()).andValidEqualTo(Boolean.TRUE);
        List<SendErpOrderMsgRecordPO> sendErpOrderMsgRecordPOList = this.sendErpOrderMsgRecordPOMapper.selectByExample(sendErpOrderMsgRecordPOExample);
        if (CollectionUtils.isEmpty(sendErpOrderMsgRecordPOList)) {
            return Boolean.FALSE;
        }
        SendErpOrderMsgRecordPO sendErpOrderMsgRecordPO = sendErpOrderMsgRecordPOList.get(0);
        SendErpOrderMsgRecordPO sendOrderMsgRecordPOUpdate = new SendErpOrderMsgRecordPO();
        sendOrderMsgRecordPOUpdate.setSendErpOrderMsgRecordId(sendErpOrderMsgRecordPO.getSendErpOrderMsgRecordId());
        sendOrderMsgRecordPOUpdate.setRefundStatus(SendOrderMsgRecordRefundStatusEnum.BEGIN.getCode());
        sendOrderMsgRecordPOUpdate.setGmtModified(new Date());
        this.sendErpOrderMsgRecordPOMapper.updateByPrimaryKeySelective(sendOrderMsgRecordPOUpdate);
        return Boolean.TRUE;
    }

    @Override
    public Boolean addIntegralOrderMsgRecord(Integer merchantId, String orderNo, IntegralOrdersPO integralOrdersPO) {
        String redisKey = "addIntegralOrderMsgRecord:" + merchantId + ":" + orderNo;
        if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)"1").booleanValue()) {
            log.warn("t_send_erp_order_msg_record\u8868\u5df2\u5b58\u5728\u8ba2\u5355:{}", (Object)orderNo);
            return Boolean.FALSE;
        }
        this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)"1", 5L, TimeUnit.MINUTES);
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<CompanyBrandRelationPO> companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        if (CollectionUtils.isEmpty(companyBrandRelationPOS)) {
            log.warn("\u5f53\u524d\u5546\u6237\u6ca1\u6709\u914d\u7f6ecompany_brand_relation\u8868");
            return Boolean.FALSE;
        }
        CompanyBrandRelationPO companyBrandRelationPO = companyBrandRelationPOS.get(0);
        SendErpOrderMsgRecordPOExample sendErpOrderMsgRecordPOExample = new SendErpOrderMsgRecordPOExample();
        sendErpOrderMsgRecordPOExample.createCriteria().andOrderNoEqualTo(orderNo).andTypeEqualTo(SendOrderMsgRecordTypeEnum.INTEGER_ORDER.getCode()).andValidEqualTo(Boolean.TRUE);
        List<SendErpOrderMsgRecordPO> sendErpOrderMsgRecordPOList = this.sendErpOrderMsgRecordPOMapper.selectByExample(sendErpOrderMsgRecordPOExample);
        if (!CollectionUtils.isEmpty(sendErpOrderMsgRecordPOList)) {
            log.warn("t_send_erp_order_msg_record\u8868\u5df2\u5b58\u5728\u79ef\u5206\u5546\u57ce\u8ba2\u5355:{}", (Object)orderNo);
            return Boolean.FALSE;
        }
        String traceId = MDC.get((String)"traceId");
        SendErpOrderMsgRecordPO sendErpOrderMsgRecordPO = new SendErpOrderMsgRecordPO();
        sendErpOrderMsgRecordPO.setMerchantId(merchantId);
        sendErpOrderMsgRecordPO.setSysBrandId(companyBrandRelationPO.getBrandId());
        sendErpOrderMsgRecordPO.setOrderNo(orderNo);
        sendErpOrderMsgRecordPO.setJsonContent(JSON.toJSONString((Object)integralOrdersPO));
        sendErpOrderMsgRecordPO.setTrace(traceId);
        sendErpOrderMsgRecordPO.setType(SendOrderMsgRecordTypeEnum.INTEGER_ORDER.getCode());
        sendErpOrderMsgRecordPO.setStatus(SendOrderMsgRecordStatusEnum.CREATE.getCode());
        sendErpOrderMsgRecordPO.setGmtCreate(new Date());
        this.sendErpOrderMsgRecordPOMapper.insertSelective(sendErpOrderMsgRecordPO);
        log.info("\u5546\u57ce\u53d1\u9001\u8bb0\u5f55id:{}", (Object)sendErpOrderMsgRecordPO.getSendErpOrderMsgRecordId());
        return Boolean.TRUE;
    }

    @Override
    public Boolean addRefundIntegralOrderMsgRecord(Integer merchantId, String refundNo, IntegralRefundOrder refundOrder) {
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<CompanyBrandRelationPO> companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        if (CollectionUtils.isEmpty(companyBrandRelationPOS)) {
            log.warn("\u5f53\u524d\u5546\u6237\u6ca1\u6709\u914d\u7f6ecompany_brand_relation\u8868");
            return Boolean.FALSE;
        }
        CompanyBrandRelationPO companyBrandRelationPO = companyBrandRelationPOS.get(0);
        SendErpOrderMsgRecordPOExample sendErpOrderMsgRecordPOExample = new SendErpOrderMsgRecordPOExample();
        sendErpOrderMsgRecordPOExample.createCriteria().andOrderNoEqualTo(refundNo).andTypeEqualTo(SendOrderMsgRecordTypeEnum.INTEGER_REFUND_ORDER.getCode()).andValidEqualTo(Boolean.TRUE);
        List<SendErpOrderMsgRecordPO> sendErpOrderMsgRecordPOList = this.sendErpOrderMsgRecordPOMapper.selectByExample(sendErpOrderMsgRecordPOExample);
        if (!CollectionUtils.isEmpty(sendErpOrderMsgRecordPOList)) {
            log.warn("t_send_erp_order_msg_record\u8868\u5df2\u5b58\u5728\u8be5\u79ef\u5206\u5546\u57ce\u9000\u5355:{}", (Object)refundNo);
            return Boolean.FALSE;
        }
        String traceId = MDC.get((String)"traceId");
        SendErpOrderMsgRecordPO sendErpOrderMsgRecordPO = new SendErpOrderMsgRecordPO();
        sendErpOrderMsgRecordPO.setMerchantId(merchantId);
        sendErpOrderMsgRecordPO.setSysBrandId(companyBrandRelationPO.getBrandId());
        sendErpOrderMsgRecordPO.setOrderNo(refundNo);
        sendErpOrderMsgRecordPO.setJsonContent(JSON.toJSONString((Object)refundOrder));
        sendErpOrderMsgRecordPO.setTrace(traceId);
        sendErpOrderMsgRecordPO.setType(SendOrderMsgRecordTypeEnum.INTEGER_REFUND_ORDER.getCode());
        sendErpOrderMsgRecordPO.setStatus(SendOrderMsgRecordStatusEnum.CREATE.getCode());
        sendErpOrderMsgRecordPO.setGmtCreate(new Date());
        this.sendErpOrderMsgRecordPOMapper.insertSelective(sendErpOrderMsgRecordPO);
        log.info("\u5546\u57ce\u53d1\u9001\u8bb0\u5f55id:{}", (Object)sendErpOrderMsgRecordPO.getSendErpOrderMsgRecordId());
        return Boolean.TRUE;
    }
}

