/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event.collect.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.CollectTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.enterprise.ShareGoodsOperatorEnum;
import com.wmeimob.fastboot.bizvane.event.collect.GoodCollectEvent;
import com.wmeimob.fastboot.bizvane.newmapper.CollectPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.po.CollectPO;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.wrapper.BrowseWrapperService;
import com.wmeimob.fastboot.bizvane.vo.collect.CollectEventVO;
import com.wmeimob.fastboot.bizvane.vo.fegin.ShareGoodsOperatorRequestVO;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class GoodCollectEnterpriseEvent
implements ApplicationListener<GoodCollectEvent> {
    private static final Logger log = LoggerFactory.getLogger(GoodCollectEnterpriseEvent.class);
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;
    @Resource
    private GoodsPOMapper goodsPOMapper;
    @Autowired
    private BrowseWrapperService browseWrapperService;
    @Resource
    private CollectPOMapper collectPOMapper;

    public void onApplicationEvent(GoodCollectEvent goodCollectEvent) {
        Integer type = goodCollectEvent.getType();
        CollectEventVO collectEventVO = goodCollectEvent.getCollectEventVO();
        Integer operator = 0;
        String operatorDesc = null;
        if (CollectTypeEnum.ADD.getCode().equals(type)) {
            log.info("\u65b0\u589e\u6536\u85cf\u4e8b\u4ef6:{}", (Object)JSON.toJSONString((Object)((Object)goodCollectEvent)));
            operator = ShareGoodsOperatorEnum.COLLECT_ADD.getCode();
            operatorDesc = ShareGoodsOperatorEnum.COLLECT_ADD.getDesc();
        } else if (CollectTypeEnum.DEL.getCode().equals(type)) {
            log.info("\u53d6\u6d88\u6536\u85cf\u4e8b\u4ef6:{}", (Object)JSON.toJSONString((Object)((Object)goodCollectEvent)));
            operator = ShareGoodsOperatorEnum.COLLECT_DEL.getCode();
            operatorDesc = ShareGoodsOperatorEnum.COLLECT_DEL.getDesc();
        } else {
            operatorDesc = "\u76f4\u63a5return";
        }
        log.info("\u6536\u85cf\u4e8b\u4ef6:{},data:{}", (Object)operatorDesc, (Object)JSON.toJSONString((Object)((Object)goodCollectEvent)));
        if (operator == 0) {
            return;
        }
        List<CollectPO> collectPOS = collectEventVO.getCollectPOS();
        for (CollectPO collectPO : collectPOS) {
            String favoriteId = collectPO.getFavoriteId();
            collectEventVO.setGoodsId(Integer.valueOf(favoriteId));
            ShareGoodsOperatorRequestVO build = this.build(collectEventVO, operator);
            if (BrowseWrapperService.SHARE_FLAG != build.getShareFlag()) {
                log.info("\u975e\u5206\u4eab\u64cd\u4f5c\u4e0d\u63a8\u9001\u5546\u79c0shareGoodsRpc/insertShareGoodsOperator.do");
                continue;
            }
            this.bizvaneInterface.insertShareGoodsOperatorUrl(build);
        }
    }

    public ShareGoodsOperatorRequestVO build(CollectEventVO collectEventVO, Integer operator) {
        String memberCode = collectEventVO.getMemberCode();
        Integer merchantId = collectEventVO.getMerchantId();
        User user = collectEventVO.getUser();
        Integer goodsId = collectEventVO.getGoodsId();
        CompanyBrandRelationPO companyBrandRelationPO = this.companyBrandRelationService.getPOByMerchantId(merchantId);
        ShareGoodsOperatorRequestVO shareGoodsOperatorRequestVO = new ShareGoodsOperatorRequestVO();
        shareGoodsOperatorRequestVO.setOperator(operator);
        shareGoodsOperatorRequestVO.setMemberCode(memberCode);
        JSONObject singleMemberInfoJSON = this.bizvaneInterface.getSingleMemberInfoJSON(memberCode);
        Integer openCardGuideId = singleMemberInfoJSON.getInteger("openCardGuideId");
        Integer openCardStoreId = singleMemberInfoJSON.getInteger("openCardStoreId");
        Integer serviceStoreId = singleMemberInfoJSON.getInteger("serviceStoreId");
        Integer serviceGuideId = singleMemberInfoJSON.getInteger("serviceGuideId");
        GoodsPO goodsPO = this.goodsPOMapper.selectByPrimaryKey(goodsId);
        shareGoodsOperatorRequestVO.setSysCompanyId(companyBrandRelationPO.getCompanyId().longValue());
        shareGoodsOperatorRequestVO.setSysBrandId(companyBrandRelationPO.getBrandId().longValue());
        shareGoodsOperatorRequestVO.setSysStaffId(serviceGuideId.toString());
        shareGoodsOperatorRequestVO.setSysStoreId(serviceStoreId.toString());
        this.browseWrapperService.fillBrowse(shareGoodsOperatorRequestVO, user);
        shareGoodsOperatorRequestVO.setGoodsId(goodsId.longValue());
        shareGoodsOperatorRequestVO.setGoodsNo(goodsPO.getGoodsNo());
        shareGoodsOperatorRequestVO.setOperator(operator);
        return shareGoodsOperatorRequestVO;
    }
}

