/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.enums.newseckill;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;

public enum SeckillActivityType {
    DAY(0, "\u6bcf\u5929"),
    WEEK(1, "\u6bcf\u5468"),
    MONTH(2, "\u6bcf\u6708"),
    CUSTOMIZE(3, "\u81ea\u5b9a\u4e49");

    private Integer code;
    private String message;

    private SeckillActivityType(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public static SeckillActivityType getByCode(Integer code) {
        SeckillActivityType[] values;
        for (SeckillActivityType value : values = SeckillActivityType.values()) {
            if (value.getCode() != code) continue;
            return value;
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static String getFormatRule(int code, String unformattedRule) {
        if (code >= 4) {
            return null;
        }
        Object[] rules = unformattedRule.split(",");
        if (ArrayUtils.isEmpty((Object[])rules)) {
            return null;
        }
        String result = null;
        switch (code) {
            case 0: {
                result = "\u6bcf\u5929";
                break;
            }
            case 1: {
                List dayOfWeek = Arrays.stream(rules).map(Integer::valueOf).map(SeckillActivityType::getWeekDay).collect(Collectors.toList());
                result = String.join((CharSequence)",", dayOfWeek);
                break;
            }
            case 2: {
                List daysOfMonth = Arrays.stream(rules).map(rule -> rule + "\u53f7").collect(Collectors.toList());
                result = String.join((CharSequence)",", daysOfMonth);
                break;
            }
            case 3: {
                result = unformattedRule;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private static String getWeekDay(int num) {
        String decribe = null;
        switch (num) {
            case 1: {
                decribe = "\u5468\u4e00";
                break;
            }
            case 2: {
                decribe = "\u5468\u4e8c";
                break;
            }
            case 3: {
                decribe = "\u5468\u4e09";
                break;
            }
            case 4: {
                decribe = "\u5468\u56db";
                break;
            }
            case 5: {
                decribe = "\u5468\u4e94";
                break;
            }
            case 6: {
                decribe = "\u5468\u516d";
                break;
            }
            case 7: {
                decribe = "\u5468\u65e5";
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
        return decribe;
    }
}

