/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.utils.response;

import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseUtil {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtil.class);
    private static final ThreadLocal<ResponseData> threadLocal = new ThreadLocal();

    public static ResponseData getResponseData() {
        ResponseData responseData = new ResponseData();
        return responseData;
    }

    public static ResponseData getSuccessData(Object data) {
        ResponseData responseData = ResponseUtil.getResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData(data);
        return responseData;
    }

    public static ResponseData getSuccessData(Object data, String msg) {
        ResponseData responseData = ResponseUtil.getResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(msg);
        responseData.setData(data);
        return responseData;
    }

    public static ResponseData getFailedData(Object data) {
        ResponseData responseData = ResponseUtil.getResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        responseData.setData(data);
        return responseData;
    }

    public static ResponseData getFailedData(Object data, String msg) {
        ResponseData responseData = ResponseUtil.getResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(msg);
        responseData.setData(data);
        return responseData;
    }

    public static ResponseData getFailedMsg(String msg) {
        ResponseData responseData = ResponseUtil.getResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(msg);
        return responseData;
    }

    public static <T> ResponseData<T> getDefaultResponse(T bean, Boolean defaultResult) {
        try {
            ResponseData<T> responseData = new ResponseData<T>();
            if (!defaultResult.booleanValue() || bean == null) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            } else {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            }
            responseData.setData(bean);
            return responseData;
        }
        catch (Exception e) {
            log.warn("ResponseUtil#getDefaultResponse\u5f02\u5e382:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return new ResponseData();
        }
    }

    public static <T> ResponseData<T> getDefaultResponse(T bean) {
        try {
            ResponseData<T> responseData = new ResponseData<T>();
            if (bean == null || bean == "") {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            } else {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            }
            responseData.setData(bean);
            return responseData;
        }
        catch (Exception e) {
            log.warn("ResponseUtil#getDefaultResponse\u5f02\u5e381:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return new ResponseData();
        }
    }

    public static ResponseData<Boolean> getBoolean(Boolean trueFalse) {
        ResponseData<Boolean> booleanResponseData = new ResponseData<Boolean>();
        if (trueFalse.booleanValue()) {
            booleanResponseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            booleanResponseData.setCode(SysResponseEnum.SUCCESS.getCode());
        } else {
            booleanResponseData.setMessage(SysResponseEnum.FAILED.getMessage());
            booleanResponseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        booleanResponseData.setData(trueFalse);
        return booleanResponseData;
    }

    public static ResponseData<Boolean> getBoolean(Boolean trueFalse, String message) {
        ResponseData<Boolean> booleanResponseData = new ResponseData<Boolean>();
        if (trueFalse.booleanValue()) {
            booleanResponseData.setMessage(message);
            booleanResponseData.setCode(SysResponseEnum.SUCCESS.getCode());
        } else {
            booleanResponseData.setMessage(message);
            booleanResponseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        booleanResponseData.setData(trueFalse);
        return booleanResponseData;
    }
}

