/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event.payorder.impl;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.OrderActivityTypeEnum;
import com.wmeimob.fastboot.bizvane.event.addorder.impl.MarketOrderAddEnterpriseListener;
import com.wmeimob.fastboot.bizvane.event.payorder.OrderPayEvent;
import com.wmeimob.fastboot.bizvane.event.payorder.impl.MarketOrderPayEnterpriseListener;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPOExample;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.impl.SendMsgToQWServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class OrderPayEnterpriseListener
implements ApplicationListener<OrderPayEvent> {
    private static final Logger log = LoggerFactory.getLogger(OrderPayEnterpriseListener.class);
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Resource
    private OrdersPOMapper ordersPOMapper;
    @Autowired
    private SendMsgToQWServiceImpl sendMsgToQWService;
    @Autowired
    private MarketOrderAddEnterpriseListener marketOrderAddEnterpriseListener;
    @Autowired
    private MarketOrderPayEnterpriseListener marketOrderPayEnterpriseListener;
    @Resource
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;

    public void onApplicationEvent(OrderPayEvent orderPayEvent) {
        Orders orders = orderPayEvent.getOrders();
        String orderNo = orders.getOrderNo();
        Integer merchantId = orders.getMerchantId();
        String ordersActivityType = orders.getOrdersActivityType();
        ArrayList<String> pushTypeList = new ArrayList<String>();
        pushTypeList.add(OrderActivityTypeEnum.PT.getCode().toString());
        pushTypeList.add(OrderActivityTypeEnum.ZB.getCode().toString());
        pushTypeList.add(OrderActivityTypeEnum.MS.getCode().toString());
        HashMap<String, OrderActivityTypeEnum> orderActivityTypeEnumHashMap = new HashMap<String, OrderActivityTypeEnum>();
        OrderActivityTypeEnum[] values = OrderActivityTypeEnum.values();
        for (int i = 0; i < values.length; ++i) {
            OrderActivityTypeEnum value = values[i];
            String key = value.getCode().toString();
            orderActivityTypeEnumHashMap.put(key, value);
        }
        if (!pushTypeList.contains(ordersActivityType)) {
            OrderActivityTypeEnum orderActivityTypeEnum = (OrderActivityTypeEnum)((Object)orderActivityTypeEnumHashMap.get(ordersActivityType));
            log.info("\u8ba2\u5355:{}\u7684\u7c7b\u578b\u4e3a:{},\u6682\u65f6\u4e0d\u63a8\u9001\u4f01\u5fae", (Object)orderNo, (Object)orderActivityTypeEnum.getDesc());
            return;
        }
        try {
            this.bizvaneInterface.notifyPaidOrderInfoToQW(orders);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u6210\u529f\u8ba2\u5355\u63a8\u9001\u4f01\u5faeerror:{}", (Throwable)e);
        }
    }

    private Orders disposeOrders(Orders orders, Integer merchantId) {
        CompanyBrandRelationPOExample companyBrandRelationPOExample = new CompanyBrandRelationPOExample();
        companyBrandRelationPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List<CompanyBrandRelationPO> companyBrandRelationPOS = this.companyBrandRelationPOMapper.selectByExample(companyBrandRelationPOExample);
        CompanyBrandRelationPO companyBrandRelationPO = companyBrandRelationPOS.get(0);
        JSONObject offlineMemberInfo = this.bizvaneInterface.getOfflineMemberInfo(companyBrandRelationPO.getCompanyId(), companyBrandRelationPO.getBrandId(), orders.getUserNo());
        if (offlineMemberInfo != null) {
            JSONObject data = offlineMemberInfo.getJSONObject("data");
            String erpId = data.getString("erpId");
            String cardNo = data.getString("cardNo");
            Integer sysServiceStoreId = data.getInteger("serviceStoreId");
            String serviceStoreId = data.getString("storeId");
            String serviceStoreCode = data.getString("serviceStoreCode");
            String serviceGuideCode = data.getString("serviceGuideCode");
            Integer serviceGuideId = data.getInteger("serviceGuideId");
            String staffId = data.getString("staffId");
            String name = data.getString("name");
            String erpStoreRemark = data.getString("remark");
            String storeName = null;
            try {
                JSONObject storeInfo = this.bizvaneInterface.getofflineStoreById(sysServiceStoreId.toString());
                storeName = storeInfo.getString("storeName");
            }
            catch (Exception e) {
                log.warn("serviceStoreId\u67e5\u8be2\u95e8\u5e97\u540d\u79f0\u5931\u8d25");
            }
            orders.setErpId(erpId);
            orders.setOfflineCardNo(cardNo);
            orders.setErpStoreId(serviceStoreId);
            orders.setErpStoreCode(serviceStoreCode);
            orders.setErpStoreName(storeName);
            orders.setErpGuideCode(serviceGuideCode);
            orders.setErpGuideId(staffId);
            orders.setVipName(name);
            orders.setSysStoreId(sysServiceStoreId.toString());
            orders.setSysStaffId(serviceGuideId.toString());
            orders.setErpStoreRemark(erpStoreRemark);
        }
        return orders;
    }

    public void dispose(Orders orders, Integer merchantId) {
        this.disposeOrders(orders, merchantId);
        this.marketOrderAddEnterpriseListener.dispose(orders);
        this.marketOrderPayEnterpriseListener.dispose(orders);
    }
}

