/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.enums.newseckill;

import com.wmeimob.fastboot.bizvane.enums.newseckill.SeckillActivityType;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum SeckillActivityStatus {
    HAVE_NOT_START(0, "\u672a\u5f00\u59cb"),
    ON_GOING(1, "\u8fdb\u884c\u4e2d"),
    HAS_ENDED(2, "\u5df2\u7ed3\u675f"),
    HAS_BEEN_STOP(3, "\u5df2\u505c\u7528");

    private Integer code;
    private String message;

    private SeckillActivityStatus(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static String getMessageFromCode(Integer code) {
        SeckillActivityStatus[] values;
        for (SeckillActivityStatus value : values = SeckillActivityStatus.values()) {
            if (value.code != code) continue;
            return value.getMessage();
        }
        return null;
    }

    public static SeckillActivityStatus correctStatus(Integer type, String rule, Date seckillBeginTime, Date seckillEndTime, boolean disabled) {
        if (disabled) {
            return HAS_BEEN_STOP;
        }
        SeckillActivityStatus currentStatus = null;
        if (type == null || StringUtils.isBlank((CharSequence)rule) || seckillBeginTime == null || seckillEndTime == null) {
            throw new MallCommonException("\u4f20\u5165\u53c2\u6570\u6709\u8bef");
        }
        Date currentTime = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentTime);
        boolean inCurrentTime = seckillBeginTime.compareTo(currentTime) < 0 && seckillEndTime.compareTo(currentTime) > 0;
        SeckillActivityType currentType = SeckillActivityType.getByCode(type);
        switch (currentType) {
            case DAY: {
                currentStatus = inCurrentTime ? ON_GOING : HAVE_NOT_START;
            }
            case WEEK: {
                String[] week = rule.split(",");
                int dayOfWeek = calendar.get(7) - 1;
                List<String> weekList = Arrays.asList(week);
                currentStatus = weekList.contains(dayOfWeek) && inCurrentTime ? ON_GOING : HAVE_NOT_START;
            }
            case MONTH: {
                String[] month = rule.split(",");
                int dayOfMonth = calendar.get(5);
                List<String> monthList = Arrays.asList(month);
                currentStatus = monthList.contains(dayOfMonth) && inCurrentTime ? ON_GOING : HAVE_NOT_START;
            }
            case CUSTOMIZE: {
                String[] date = rule.split("~");
                Date begin = DateUtil.parse(date[0], "yyyy-MM-dd");
                Date end = DateUtil.parse(date[1], "yyyy-MM-dd");
                end.setHours(24);
                if (currentTime.compareTo(end) > 0) {
                    currentStatus = HAS_ENDED;
                }
                currentStatus = currentTime.compareTo(begin) < 0 && currentTime.compareTo(end) > 0 && inCurrentTime ? ON_GOING : HAVE_NOT_START;
                break;
            }
        }
        if (currentStatus == null) {
            throw new MallCommonException("\u4f20\u5165\u53c2\u6570\u6709\u8bef");
        }
        return currentStatus;
    }

    public static boolean checkStatus(SeckillActivityStatus activityStatus) {
        return HAS_ENDED.getCode().equals(activityStatus.getCode()) || HAS_BEEN_STOP.getCode().equals(activityStatus.getCode());
    }
}

