/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.event.commission.impl;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.bo.UserCommissionAccountLogsBo;
import com.wmeimob.fastboot.bizvane.event.commission.CommissionIntegralEvent;
import com.wmeimob.fastboot.bizvane.event.commission.impl.CommissionIntegralServiceImpl;
import com.wmeimob.fastboot.bizvane.newmapper.UserCommissionAccountLogsPOMapper;
import com.wmeimob.fastboot.bizvane.po.UserCommissionAccountLogsPOExample;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class CommissionIntegralEventListener
implements ApplicationListener<CommissionIntegralEvent> {
    private static final Logger log = LoggerFactory.getLogger(CommissionIntegralEventListener.class);
    @Resource
    private UserCommissionAccountLogsPOMapper userCommissionAccountLogsPOMapper;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private CommissionIntegralServiceImpl commissionIntegralService;

    @Async
    public void onApplicationEvent(CommissionIntegralEvent commissionIntegralEvent) {
        log.info("CommissionIntegralEventListener Listener,received successful,commissionIntegralEvent:{}", (Object)JSONObject.toJSONString((Object)((Object)commissionIntegralEvent)));
        List<UserCommissionAccountLogsBo> userCommissionAccountLogsBoList = commissionIntegralEvent.getUserCommissionAccountLogsBoList();
        if (CollectionUtils.isEmpty(userCommissionAccountLogsBoList)) {
            log.info("CommissionIntegralEventListener Listener,userCommissionAccountLogsBoList is empty");
            return;
        }
        for (UserCommissionAccountLogsBo userCommissionAccountLogsBo : userCommissionAccountLogsBoList) {
            log.info("CommissionIntegralEventListener Listener,userNo:{},orderNo:{},\u5224\u65ad\u662f\u5426\u5df2\u540c\u6b65", (Object)userCommissionAccountLogsBo.getUserNo(), (Object)userCommissionAccountLogsBo.getOrderNo());
            String redisKey = "CommissionIntegralEventListener:" + userCommissionAccountLogsBo.getOrderNo() + "_" + userCommissionAccountLogsBo.getUserNo();
            if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)"1").booleanValue()) {
                log.info("CommissionIntegralEventListener Listener,userNo:{},orderNo:{},redis \u5df2\u7ecf\u540c\u6b65\u6210\u529f,\u65e0\u9700\u518d\u540c\u6b65", (Object)userCommissionAccountLogsBo.getUserNo(), (Object)userCommissionAccountLogsBo.getOrderNo());
                continue;
            }
            this.stringRedisTemplate.expire((Object)redisKey, 10L, TimeUnit.SECONDS);
            UserCommissionAccountLogsPOExample userCommissionAccountLogsPOExample = new UserCommissionAccountLogsPOExample();
            userCommissionAccountLogsPOExample.createCriteria().andIdEqualTo(userCommissionAccountLogsBo.getId()).andSyncCrmStatusEqualTo((byte)1).andValidEqualTo(Boolean.TRUE);
            long count = this.userCommissionAccountLogsPOMapper.countByExample(userCommissionAccountLogsPOExample);
            if (count > 0L) {
                log.info("CommissionIntegralEventListener Listener,userNo:{},orderNo:{},\u5df2\u7ecf\u540c\u6b65\u6210\u529f,\u65e0\u9700\u518d\u540c\u6b65", (Object)userCommissionAccountLogsBo.getUserNo(), (Object)userCommissionAccountLogsBo.getOrderNo());
                continue;
            }
            try {
                this.commissionIntegralService.commissionIntegralSyncCrm(userCommissionAccountLogsBo);
            }
            catch (Exception exception) {
                log.error("CommissionIntegralEventListener Listener,userNo:{},orderNo:{},\u540c\u6b65\u5931\u8d25:{}", new Object[]{userCommissionAccountLogsBo.getUserNo(), userCommissionAccountLogsBo.getOrderNo(), ExceptionUtils.getStackTrace((Throwable)exception)});
                this.stringRedisTemplate.delete((Object)redisKey);
            }
        }
    }
}

