/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.baison.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.StringUtil;
import com.mzlion.core.json.gson.JsonUtil;
import com.wmeimob.fastboot.baison.dto.requestVO.BaisonOrderAddItems;
import com.wmeimob.fastboot.baison.dto.requestVO.BaisonOrderAddRequestVO;
import com.wmeimob.fastboot.baison.dto.requestVO.BaisonOrderCancelDelivery;
import com.wmeimob.fastboot.baison.dto.requestVO.BaisonOrderDetailGetRequestVO;
import com.wmeimob.fastboot.baison.dto.requestVO.BaisonOrderDetailGetV2RequestVO;
import com.wmeimob.fastboot.baison.dto.requestVO.BaisonOrderReturnAdd;
import com.wmeimob.fastboot.baison.dto.requestVO.BaisonOrderReturnAddItems;
import com.wmeimob.fastboot.baison.dto.requestVO.BaisonOrderZwxRequestVO;
import com.wmeimob.fastboot.baison.dto.requestVO.BaisonUpdateWxRefundRequestVO;
import com.wmeimob.fastboot.baison.dto.requestVO.BiasonReturnOrderGetVo;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonOrderDetailGetBusinessDataResponse;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonOrderDetailGetResponseVO;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonResponseDTO;
import com.wmeimob.fastboot.baison.dto.responseVO.BiasonReturnOrderResponseAll;
import com.wmeimob.fastboot.baison.dto.responseVO.BiasonReturnOrderResponseData;
import com.wmeimob.fastboot.baison.service.E3OrderService;
import com.wmeimob.fastboot.baison.utils.BaisonOrderUtil;
import com.wmeimob.fastboot.baison.utils.BaisonUtil2;
import com.wmeimob.fastboot.baison.utils.Calculate;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="e3Service")
public class OrderServiceImpl
implements E3OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private BaisonUtil2 baisonUtil2;
    @Autowired
    private BaisonOrderUtil baisonOrderUtil;

    @Override
    public BaisonOrderDetailGetResponseVO orderDetailGet(BaisonOrderDetailGetRequestVO requestVO) {
        log.info("==========\u8fdb\u5165e3\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u63a5\u53e3=========");
        log.info("requestVO:{}", (Object)requestVO);
        String jsonParams = JsonUtil.toJson((Object)requestVO, (String[])new String[]{"serviceType"});
        BaisonResponseDTO post = this.baisonUtil2.getBaiSonE3Response(requestVO.getServiceType(), jsonParams);
        BaisonOrderDetailGetResponseVO responseVO = null;
        if (post != null) {
            log.info("E3\u8fd4\u56de\u7684\u6570\u636e=======:{}", (Object)post);
            String status = post.getStatus();
            String message = post.getMessage();
            String data = post.getData();
            JSONObject newData = JSONObject.parseObject((String)data);
            responseVO = new BaisonOrderDetailGetResponseVO();
            BaisonOrderDetailGetBusinessDataResponse response = (BaisonOrderDetailGetBusinessDataResponse)JSONObject.parseObject((String)data, BaisonOrderDetailGetBusinessDataResponse.class);
            responseVO.setStatus(status);
            responseVO.setMessage(message);
            responseVO.setData(response);
        } else {
            responseVO.setMessage("E3\u8fd4\u56de\u7684\u6570\u636enull");
        }
        return responseVO;
    }

    @Override
    public BaisonResponseDTO orderAdd(Orders commonOrder) {
        log.info("==========\u8fdb\u5165e3\u8ba2\u5355\u6dfb\u52a0\u63a5\u53e3=========");
        BaisonResponseDTO responseDTO = new BaisonResponseDTO();
        BaisonOrderAddRequestVO addRequestVO = new BaisonOrderAddRequestVO();
        ArrayList<BaisonOrderAddItems> orderAddItems = new ArrayList<BaisonOrderAddItems>();
        DateUtil dateUtil = new DateUtil();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        addRequestVO.setAdd_time(sdf.format(new Date()));
        if (StringUtil.isEmpty((String)commonOrder.getOrderNo())) {
            responseDTO.setStatus("INVALID_PARAMS");
            responseDTO.setMessage("\u8ba2\u5355\u53f7\u4e3a\u7a7a");
            return responseDTO;
        }
        addRequestVO.setOrder_sn(commonOrder.getOrderNo());
        addRequestVO.setSd_code("IW001");
        addRequestVO.setOrder_status(1);
        addRequestVO.setPay_status(2);
        addRequestVO.setConsignee(commonOrder.getUserId() != null ? String.valueOf(commonOrder.getUserId()) : "");
        addRequestVO.setProvince_name(commonOrder.getShippingProvince());
        addRequestVO.setCity_name(commonOrder.getShippingCity());
        addRequestVO.setAddress(commonOrder.getShippingAddress());
        addRequestVO.setDistrict_name(commonOrder.getShippingDistrict());
        addRequestVO.setUser_name(commonOrder.getUserName());
        addRequestVO.setMobile(commonOrder.getMobile());
        addRequestVO.setSaleShopCode(commonOrder.getSysStoreId());
        addRequestVO.setSalerEmployeeNo(commonOrder.getErpGuideId());
        addRequestVO.setPay_code("alipay");
        addRequestVO.setVip_no(commonOrder.getUserNo());
        addRequestVO.setShipping_code(commonOrder.getShippingVendor());
        addRequestVO.setShipping_fee(commonOrder.getShippingFee() != null ? String.valueOf(commonOrder.getShippingFee()) : "");
        addRequestVO.setOrder_amount(commonOrder.getOrderAmount() != null ? String.valueOf(commonOrder.getOrderAmount()) : "");
        addRequestVO.setPayment(commonOrder.getOrderAmount() != null ? String.valueOf(commonOrder.getPayAmount()) : "");
        if (commonOrder.getItems() != null) {
            for (OrderItems items : commonOrder.getItems()) {
                BaisonOrderAddItems addItems = new BaisonOrderAddItems();
                addItems.setSku_sn(items.getGoodsSkuNo());
                addItems.setGoods_number(items.getSaleQuantity());
                addItems.setGoods_price(items.getSalePrice() != null ? String.valueOf(items.getSalePrice()) : "");
                Double realPrice = 0.0;
                if (items.getItemsPayAmount() != null) {
                    realPrice = Calculate.division(items.getItemsPayAmount().doubleValue(), (double)items.getSaleQuantity());
                    addItems.setTransaction_price(String.valueOf(realPrice));
                }
                if (realPrice != 0.0 && items.getSalePrice() != null) {
                    Double salPr = items.getSalePrice().doubleValue();
                    addItems.setDiscount(Calculate.division(realPrice, salPr).toString());
                }
                addItems.setIs_gift(0);
                orderAddItems.add(addItems);
            }
            addRequestVO.setItems(orderAddItems);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        JSONArray jsonArray = JSONArray.fromObject((Object)addRequestVO);
        jsonArray.remove((Object)"serviceType");
        result.put("total", 1);
        result.put("data", (Integer)jsonArray);
        String jsParams = JsonUtil.toJson(result);
        log.info("orderAdd \u8ba2\u5355\u6570\u636e\uff1a{}", (Object)jsParams);
        responseDTO = this.baisonUtil2.getBaiSonE3Response(addRequestVO.getServiceType(), jsParams);
        log.info("\u5411E3\u63a8\u9001\u8ba2\u5355\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)responseDTO));
        return responseDTO;
    }

    @Override
    public BaisonResponseDTO orderZwx(BaisonOrderZwxRequestVO requestVO) {
        log.info("==========\u8fdb\u5165e3\u8ba2\u5355\u7f6e\u65e0\u6548\u63a5\u53e3=========");
        log.info("requestVO:{}", (Object)requestVO);
        BaisonResponseDTO baisonResponseDTO = new BaisonResponseDTO();
        String jsonParams = JsonUtil.toJson((Object)requestVO, (String[])new String[]{"serviceType"});
        BaisonResponseDTO post = null;
        try {
            post = this.baisonUtil2.getBaiSonE3Response(requestVO.getServiceType(), jsonParams);
        }
        catch (Exception e) {
            log.info("e3\u8ba2\u5355\u7f6e\u65e0\u6548\u63a5\u53e3\u5931\u8d25!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!:{}", (Object[])e.getStackTrace());
        }
        log.info("e3\u8ba2\u5355\u7f6e\u65e0\u6548\u63a5\u53e3\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)post));
        return post;
    }

    @Override
    public BaisonResponseDTO updateWxRefund(BaisonUpdateWxRefundRequestVO refundRequestVO) {
        log.info("==========\u8fdb\u5165e3\u4f5c\u5e9f\u9500\u552e\u9000\u5355\u63a5\u53e3=========");
        log.info("requestVO:{}", (Object)refundRequestVO);
        BaisonResponseDTO baisonResponseDTO = new BaisonResponseDTO();
        if (StringUtils.isEmpty((String)refundRequestVO.getOrderCode())) {
            log.info("========\u975e\u7a7a\u8ba2\u5355\u53f7:{}===========", (Object)refundRequestVO.getOrderCode());
            baisonResponseDTO.setStatus("INVALID_PARAMS");
            baisonResponseDTO.setMessage("\u8ba2\u5355\u53f7null");
            return baisonResponseDTO;
        }
        String jsonParams = JsonUtil.toJson((Object)refundRequestVO, (String[])new String[]{"serviceType"});
        BaisonResponseDTO baisonResponse = null;
        try {
            baisonResponse = this.baisonUtil2.getBaiSonE3Response(refundRequestVO.getServiceType(), jsonParams);
        }
        catch (Exception e) {
            log.info("\u4f5c\u5e9f\u9500\u552e\u9000\u5355\u63a5\u53e3\u5931\u8d25!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!:{}", (Object[])e.getStackTrace());
        }
        log.info("==========\u4f5c\u5e9f\u9500\u552e\u9000\u5355\u63a5\u53e3\u5de6\u540e\u8fd4\u56de\u6570\u636e============:{}", (Object)JSON.toJSONString((Object)baisonResponse));
        return baisonResponse;
    }

    @Override
    public BaisonResponseDTO orderReturnAdd(Orders requestVO) {
        log.info("==========\u8fdb\u5165e3\u9000\u5355\u6dfb\u52a0\u63a5\u53e3=========");
        log.info("\u53c2\u6570\uff1a{}", (Object)requestVO);
        ArrayList<BaisonOrderReturnAddItems> itemsList = new ArrayList<BaisonOrderReturnAddItems>();
        BaisonResponseDTO responseDTO = new BaisonResponseDTO();
        BaisonOrderReturnAdd orderReturnAdd = new BaisonOrderReturnAdd();
        String e3OrderNo = this.baisonOrderUtil.getE3OrderNo(requestVO.getOrderNo());
        orderReturnAdd.setDeal_code(requestVO.getOrderNo());
        orderReturnAdd.setOrder_sn(e3OrderNo);
        log.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>:{}", (Object)JSON.toJSONString(requestVO.getItems()));
        if (requestVO.getItems() != null) {
            for (OrderItems item : requestVO.getItems()) {
                BaisonOrderReturnAddItems item1 = new BaisonOrderReturnAddItems();
                item1.setSku(item.getGoodsSkuNo());
                item1.setGoods_number(item.getSaleQuantity());
                item1.setMarket_price(item.getMarketPrice());
                item1.setShop_price(item.getSalePrice());
                if (item.getItemsPayAmount() != null && item.getSaleQuantity() != null) {
                    item1.setGoods_price(Calculate.division(item.getItemsPayAmount().doubleValue(), (double)item.getSaleQuantity()));
                }
                itemsList.add(item1);
            }
        }
        orderReturnAdd.setOrder_return_goods(itemsList);
        HashMap<String, BaisonOrderReturnAdd> result = new HashMap<String, BaisonOrderReturnAdd>();
        result.put("sell_return_record", orderReturnAdd);
        String jsonObject = JsonUtil.toJson(result, (String[])new String[]{"serviceType"});
        log.info("jsonObject:{}", (Object)jsonObject);
        responseDTO = this.baisonUtil2.getBaiSonE3Response(orderReturnAdd.getServiceType(), jsonObject);
        log.info("e3\u9000\u5355\u6dfb\u52a0\u63a5\u53e3:{}", (Object)JSON.toJSONString((Object)responseDTO));
        return responseDTO;
    }

    @Override
    public BaisonResponseDTO orderCancelDelivery(BaisonOrderCancelDelivery requestVO) {
        log.info("==========\u8fdb\u5165e3\u8ba2\u5355\u53d6\u6d88\u53d1\u8d27=========");
        log.info("\u53c2\u6570\uff1a{}", (Object)requestVO);
        BaisonResponseDTO responseDTO = new BaisonResponseDTO();
        requestVO.setLy_type("openshop");
        String jsonObject = JsonUtil.toJson((Object)requestVO, (String[])new String[]{"serviceType"});
        log.info("jsonObject:{}", (Object)jsonObject);
        responseDTO = this.baisonUtil2.getBaiSonE3Response(requestVO.getServiceType(), jsonObject);
        log.info("\u53d6\u6d88\u8ba2\u5355\u53d1\u8d27\u63a5\u53e3:{}", (Object)JSON.toJSONString((Object)responseDTO));
        return responseDTO;
    }

    @Override
    public BaisonOrderDetailGetResponseVO orderDetailGetV2(BaisonOrderDetailGetV2RequestVO requestVO) {
        log.info("==========\u8fdb\u5165e3\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u63a5\u53e3===orderDetailGetV2======");
        log.info("requestVO:{}", (Object)requestVO);
        String jsonParams = JsonUtil.toJson((Object)requestVO, (String[])new String[]{"serviceType"});
        BaisonResponseDTO post = null;
        try {
            post = this.baisonUtil2.getBaiSonE3Response(requestVO.getServiceType(), jsonParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaisonOrderDetailGetResponseVO responseVO = null;
        if (post != null) {
            log.info("orderDetailGetV2E3\u8fd4\u56de\u7684\u6570\u636e=======:{}", (Object)post);
            String status = post.getStatus();
            String message = post.getMessage();
            String data = post.getData();
            JSONObject newData = JSONObject.parseObject((String)data);
            responseVO = new BaisonOrderDetailGetResponseVO();
            BaisonOrderDetailGetBusinessDataResponse response = (BaisonOrderDetailGetBusinessDataResponse)JSONObject.parseObject((String)data, BaisonOrderDetailGetBusinessDataResponse.class);
            responseVO.setStatus(status);
            responseVO.setMessage(message);
            responseVO.setData(response);
        } else {
            responseVO.setMessage("orderDetailGetV2E3\u8fd4\u56de\u7684\u6570\u636enull");
        }
        return responseVO;
    }

    @Override
    public BiasonReturnOrderResponseAll returnDetailGet(BiasonReturnOrderGetVo requestVO) {
        log.info("==========\u8fdb\u5165e3\u83b7\u53d6\u9000\u5355\u4fe1\u606f\u63a5\u53e3=========");
        log.info("e3\u83b7\u53d6\u9000\u5355\u4fe1\u606f\u63a5\u53e3\u5165\u53c2:{}", (Object)requestVO);
        String jsonParams = JsonUtil.toJson((Object)requestVO, (String[])new String[]{"serviceType"});
        BaisonResponseDTO post = this.baisonUtil2.getBaiSonE3Response(requestVO.getServiceType(), jsonParams);
        BiasonReturnOrderResponseAll responseVO = null;
        if (post != null) {
            log.info("e3\u83b7\u53d6\u9000\u5355\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e=======:{}", (Object)JSON.toJSONString((Object)post));
            String status = post.getStatus();
            String message = post.getMessage();
            String data = post.getData();
            JSONObject newData = JSONObject.parseObject((String)data);
            responseVO = new BiasonReturnOrderResponseAll();
            BiasonReturnOrderResponseData response = (BiasonReturnOrderResponseData)JSONObject.parseObject((String)data, BiasonReturnOrderResponseData.class);
            responseVO.setStatus(status);
            responseVO.setMessage(message);
            responseVO.setData(response);
        } else {
            responseVO.setMessage("E3\u8fd4\u56de\u7684\u6570\u636enull");
        }
        log.info("e3\u83b7\u53d6\u9000\u5355\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e:{}", (Object)responseVO);
        return responseVO;
    }
}

