package com.bizvane.basic.feign.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 操作日志vo
 */
@Getter
@Setter
@ApiModel(value = "操作日志vo", description = "操作日志")
public class TSysOperationLogVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("操作人code")
    private String userCode;

    @ApiModelProperty("操作人名字")
    private String userName;

    @ApiModelProperty("操作人手机号")
    private String phone;

    @ApiModelProperty("所属组织")
    private String orgCode;

    @ApiModelProperty("所属组织名称")
    private String orgName;

    @ApiModelProperty("操作类型")
    private String type;

    @ApiModelProperty("操作模块")
    private String module;

    @ApiModelProperty("功能")
    private String function;

    @ApiModelProperty("功能明细")
    private String functionDetail;

    @ApiModelProperty("旧内容")
    private String oldContent;

    @ApiModelProperty("新内容")
    private String newContent;

    @ApiModelProperty("请求")
    private String request;

    @ApiModelProperty("响应")
    private String result;

    @ApiModelProperty("ip")
    private String ip;

    @ApiModelProperty("操作时间")
    private Date createTime;

    @ApiModelProperty("有效")
    private Boolean valid;
}
