package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.req.TBaseDictGeneralReq;
import com.bizvane.basic.feign.model.rsp.TBaseDictGeneralRsp;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tBasicDictGeneral")
@Api(value = "字典信息RPC")
public interface BasicDictGeneralRpcFeign {

    @RequestMapping(value = "/getDictGeneral", method = RequestMethod.POST)
    @ApiOperation(value = "查询字典",notes = "根据字典typeCode查询字典值")
    ResponseData<List<TBaseDictGeneralRsp>> getDictGeneral(@RequestBody @Validated TBaseDictGeneralReq req);


    @RequestMapping(value = "/getDictGeneralByCode", method = RequestMethod.POST)
    @ApiOperation(value = "查询字典code",notes = "根据字典typeCode和code查询字典值")
    ResponseData<TBaseDictGeneralRsp> getDictGeneralByCode(@RequestBody @Validated TBaseDictGeneralReq req);

}
