package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.vo.TBasicAirportVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tBasicAirport")
@Api(value = "机场RPC")
public interface BasicAirportRpcFeign {

    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ApiOperation(value = "机场列表")
    ResponseData<List<TBasicAirportVo>> list(@RequestBody TBasicAirportVo req);

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "添加机场")
    ResponseData<Boolean> save(@RequestBody TBasicAirportVo req);

    @RequestMapping(value = "/modify", method = RequestMethod.POST)
    @ApiOperation(value = "修改机场")
    ResponseData<Boolean> modify(@RequestBody TBasicAirportVo req);

    @RequestMapping(value = "/detail", method = RequestMethod.POST)
    @ApiOperation(value = "详情")
    ResponseData<TBasicAirportVo> detail(@RequestBody TBasicAirportVo req);



}
