package com.bizvane.basic.feign.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * 审批任务状态（0等待前置审核 1审核中 2审核通过 3审核拒绝 4审核超时 5审核撤销）
 */
@Getter
public enum ApproveTaskStatusEnum {

    WAIT_APPROVE(0, "等待前置审核"),
    APPROVE_PROCESSING(1, "审核中"),
    APPROVE_PASS(2, "审核通过"),
    APPROVE_REJECT(3, "审核拒绝"),
    APPROVE_TIMEOUT(4, "审核超时"),
    APPROVE_QUASH(5, "审核撤销");

    private final Integer code;
    private final String value;

    ApproveTaskStatusEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }


    public static ApproveTaskStatusEnum getByCode(Integer code) {
        for (ApproveTaskStatusEnum value : ApproveTaskStatusEnum.values()) {
            if (Objects.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }
}
